/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.commons.interceptor;

import io.gitlab.rujal_sh.commons.TenantContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public class RequestInterceptor
extends WebRequestHandlerInterceptorAdapter {
    public RequestInterceptor(WebRequestInterceptor requestInterceptor) {
        super(requestInterceptor);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tenantId = request.getHeader("TenantId");
        if (tenantId != null) {
            TenantContext.setCurrentTenant(tenantId);
            return true;
        }
        response.getWriter().write("TenantId not present in the Request Header");
        response.setStatus(400);
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        TenantContext.clear();
    }
}

