/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.commons;

import io.gitlab.rujal_sh.commons.SqlExecutions;
import io.gitlab.rujal_sh.database.domain.DataSourceConfig;
import io.gitlab.rujal_sh.database.repo.DataSourceConfigRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class TenantDataSource
extends SqlExecutions
implements Serializable {
    private final GenericWebApplicationContext context;
    private final BeanFactory beanFactory;
    public static Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public TenantDataSource(GenericWebApplicationContext context, BeanFactory beanFactory) {
        this.context = context;
        this.beanFactory = beanFactory;
    }

    @Bean
    public JpaRepositoryFactoryBean<DataSourceConfigRepository, DataSourceConfig, Long> dataSourceConfigRepository() {
        JpaRepositoryFactoryBean jpaRepositoryFactoryBean = new JpaRepositoryFactoryBean(DataSourceConfigRepository.class);
        return jpaRepositoryFactoryBean;
    }

    @Bean
    @ConditionalOnBean(value={DataSourceConfigRepository.class})
    public void getAll() {
        DataSourceConfigRepository dataSourceConfigRepository = (DataSourceConfigRepository)this.beanFactory.getBean(DataSourceConfigRepository.class);
        List configList = dataSourceConfigRepository.findAll();
        HashMap<String, DataSource> result = new HashMap<String, DataSource>();
        for (DataSourceConfig config : configList) {
            result.put(config.getName(), this.createDataSource(config));
        }
        dataSources = result;
    }
}

