package io.gitlab.rujal_sh.commons;

import io.gitlab.rujal_sh.database.domain.DataSourceConfig;
import io.gitlab.rujal_sh.database.repo.DataSourceConfigRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.context.support.GenericWebApplicationContext;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantDataSource implements Serializable {

    private final GenericWebApplicationContext context;
    private final BeanFactory beanFactory;

    public static Map<String, DataSource> dataSources = new HashMap<>();

    public TenantDataSource(GenericWebApplicationContext context,
                            BeanFactory beanFactory){
        this.context = context;
        this.beanFactory = beanFactory;
    }

    @RequiredArgsConstructor
    @Lazy
    private static class AssignTenantDataSource extends SqlExecutions {

        private final BeanFactory beanFactory;

        private DataSourceConfigRepository dataSourceConfigRepository;

        @PostConstruct
        private void getAll() {
            dataSourceConfigRepository = beanFactory.getBean(DataSourceConfigRepository.class);
            List<DataSourceConfig> configList = dataSourceConfigRepository.findAll();
            Map<String, DataSource> result = new HashMap<>();
            for (DataSourceConfig config : configList) {
                result.put(config.getName(), createDataSource(config));
            }
            TenantDataSource.dataSources = result;
        }
    }
}