package io.gitlab.rujal_sh.commons;

import io.gitlab.rujal_sh.database.domain.DataSourceConfig;
import org.springframework.boot.jdbc.DataSourceBuilder;

import javax.sql.DataSource;

class SqlExecutions {

    DataSource createDataSource(DataSourceConfig dataSourceConfig) {
        if (dataSourceConfig != null) {
            DataSourceBuilder factory = DataSourceBuilder
                    .create().driverClassName(dataSourceConfig.getDriverClassName())
                    .username(dataSourceConfig.getUsername())
                    .password(dataSourceConfig.getPassword())
                    .url(dataSourceConfig.getUrl());
            DataSource ds = factory.build();
            return ds;
        }
        return null;
    }
}
