package io.gitlab.rujal_sh.annotation;

import io.gitlab.rujal_sh.commons.*;
import io.gitlab.rujal_sh.commons.interceptor.RequestInterceptor;
import io.gitlab.rujal_sh.commons.utils.Constants;
import io.gitlab.rujal_sh.database.DataSourceBasedMultiTenantConnectionProviderImpl;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@AutoConfigurationPackage
@Import({RequestInterceptor.class,
        Constants.class,
        StaticResourceConfiguration.class,
        PersistenceJPAConfig.class,
        TenantSchemaResolver.class,
        DBTenantHelper.class,
        JpaHibernateProperties.class,
        DataSourceBasedMultiTenantConnectionProviderImpl.class,
        TenantDataSource.class})
public @interface Database_Based_MultiTenancy {

    String[] basePackages() default {};

}
