/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rujal_sh.db.config;

import com.zaxxer.hikari.HikariDataSource;
import io.gitlab.rujal_sh.annotation.StrategyType;
import io.gitlab.rujal_sh.annotation.TenantHolder;
import io.gitlab.rujal_sh.annotation.internal.DataSourceConfiguration;
import io.gitlab.rujal_sh.commons.CustomEntityManagerFactoryBean;
import io.gitlab.rujal_sh.commons.JpaHibernateProperties;
import io.gitlab.rujal_sh.commons.PersistenceJPAConfig;
import io.gitlab.rujal_sh.commons.utils.Constants;
import io.gitlab.rujal_sh.db.config.SqlExecutions;
import io.gitlab.rujal_sh.db.config.TenantDataSource;
import io.gitlab.rujal_sh.db.config.domain.DataSourceConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.web.context.support.GenericWebApplicationContext;

@Aspect
public class DBTenantHelper
extends SqlExecutions {
    private final DataSource dataSource;
    private final BeanFactory beanFactory;
    private final GenericWebApplicationContext context;
    private final JpaHibernateProperties jpaHibernateProperties;
    private final CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private final Optional<TenantDataSource> optionalTenantDataSource;
    private final MultiTenantConnectionProvider multiTenantConnectionProvider;
    private PersistenceJPAConfig persistenceJPAConfig;
    private DataSourceConfig dataSourceConfig;

    @Around(value="execution(* org.springframework.data.repository.CrudRepository+.save(..)) && args(entity)")
    public Object test(ProceedingJoinPoint proceedingJoinPoint, Object entity) throws Throwable {
        String userName = null;
        List annotationList = Arrays.asList(entity.getClass().getAnnotations()).stream().filter(annotation -> annotation instanceof TenantHolder).collect(Collectors.toList());
        if (!annotationList.isEmpty()) {
            this.persistenceJPAConfig = new PersistenceJPAConfig(this.jpaHibernateProperties, this.dataSource, this.multiTenantConnectionProvider, this.currentTenantIdentifierResolver, (ApplicationContext)this.context);
            DataSourceConfig dbConfig = this.getDataSourceConfig(entity);
            try {
                Method methodUserName = entity.getClass().getDeclaredMethod("getName", new Class[0]);
                userName = String.valueOf(methodUserName.invoke(entity, new Object[0]));
            }
            catch (NoSuchMethodException ne) {
                Method methodUserName = entity.getClass().getDeclaredMethod("getUsername", new Class[0]);
                userName = String.valueOf(methodUserName.invoke(entity, new Object[0]));
            }
            CrudRepository crudRepository = (CrudRepository)proceedingJoinPoint.getThis();
            List<Object> result = new ArrayList();
            crudRepository.findAll().forEach(result::add);
            DataSourceConfig finalDbConfig = dbConfig;
            result = result.stream().filter(entityFromRepo -> this.checkDbConfiguration(entityFromRepo, finalDbConfig)).collect(Collectors.toList());
            if (result.isEmpty()) {
                this.performDatabaseAction(entity, dbConfig, userName, Constants.strategy);
            }
            proceedingJoinPoint.proceed();
            this.createTables(userName, this.getValue(entity, "dataSourceConfig", DataSourceConfig.class));
        } else {
            proceedingJoinPoint.proceed();
        }
        return proceedingJoinPoint;
    }

    private void performDatabaseAction(Object entity, DataSourceConfig dbConfig, String userName, StrategyType strategy) throws SQLException {
        if (!dbConfig.getGenerate().booleanValue()) {
            this.testDbConnection(dbConfig);
        } else {
            this.dataSourceConfig = dbConfig = this.getTenantWiseDataSourceConfig(userName);
            switch (strategy) {
                case SCHEMA: {
                    this.createTenantSchema(userName);
                    break;
                }
                case DATABASE: {
                    this.createDatabase(userName);
                    this.optionalTenantDataSource.get();
                    TenantDataSource.dataSources.put(dbConfig.getName(), this.createDataSource(this.dataSourceConfig));
                }
            }
            this.setValue(entity, "dataSourceConfig", dbConfig, DataSourceConfig.class);
        }
    }

    private void createTenantSchema(String tenantName) throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.createStatement().execute(String.format("CREATE SCHEMA IF NOT EXISTS %s", tenantName));
        connection.setSchema(tenantName);
    }

    private DataSourceConfig getTenantWiseDataSourceConfig(String tenantId) {
        HikariDataSource dataSourceH = (HikariDataSource)this.dataSource;
        DataSourceConfig dataSourceConfig = DataSourceConfig.builder().driverClassName(dataSourceH.getDriverClassName()).name(tenantId).username(dataSourceH.getUsername()).generate(true).password(dataSourceH.getPassword()).initialize(true).url(this.generateUrl(tenantId, dataSourceH.getJdbcUrl())).build();
        return dataSourceConfig;
    }

    private String generateUrl(String tenantId, String jdbcUrl) {
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(jdbcUrl.split("/")));
        strings.add(strings.size(), tenantId);
        strings.remove(strings.size() - 2);
        return String.join((CharSequence)"/", strings);
    }

    private void testDbConnection(DataSourceConfig dbConfig) {
        try {
            Class.forName(dbConfig.getDriverClassName());
            Connection connection = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUsername(), dbConfig.getPassword());
            if (connection == null) {
                throw new RuntimeException(String.format("Driver connection to URL %s failed", dbConfig.getUrl()));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    private boolean checkDbConfiguration(Object entityRepo, DataSourceConfig dbConfig) {
        DataSourceConfig dataSource;
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig(dbConfig);
        return dataSourceConfig != null && (dataSource = (DataSourceConfig)entityRepo).getUsername().equalsIgnoreCase(dbConfig.getUsername());
    }

    private DataSourceConfig getDataSourceConfig(Object entity) {
        try {
            String fieldName = this.getFieldNameWithAnnotationDataSourceConfiguration(entity);
            Method methodId = entity.getClass().getSuperclass().getDeclaredMethod("get" + fieldName, new Class[0]);
            Object dbConfig = methodId.invoke(entity, new Object[0]);
            if (dbConfig != null) {
                return (DataSourceConfig)dbConfig;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    private void createDatabase(String tenantName) throws SQLException {
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create().driverClassName(((HikariDataSource)this.dataSource).getDriverClassName()).username(((HikariDataSource)this.dataSource).getUsername()).password(((HikariDataSource)this.dataSource).getPassword()).url(((HikariDataSource)this.dataSource).getJdbcUrl());
        DataSource ds = dataSourceBuilder.build();
        Connection connection = ds.getConnection();
        Statement statement = connection.createStatement();
        if (!tenantName.equalsIgnoreCase("public")) {
            try {
                statement.execute(String.format("create database %s", tenantName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getFieldNameWithAnnotationDataSourceConfiguration(Object entity) {
        List<Field> fields = Arrays.asList(entity.getClass().getSuperclass().getDeclaredFields());
        if (fields.size() != 0) {
            int count = 0;
            Field field = null;
            for (Field f : fields) {
                Optional<Annotation> schemaFields = Arrays.asList(f.getAnnotations()).stream().filter(annotation -> annotation instanceof DataSourceConfiguration).findFirst();
                if (!schemaFields.isPresent()) continue;
                field = f;
                ++count;
            }
            if (count != 1) {
                throw new RuntimeException("Fields cannot be annotated with '@DataSourceConfiguration' more than once");
            }
            String fieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            return fieldName;
        }
        throw new RuntimeException("Consider extending class 'DataSourceComponent' in class annotated with @TenantHolder");
    }

    private String createBean(String tenantId, DataSourceConfig dbConfig) {
        String beanName = "entityManagerFactory" + tenantId;
        this.context.registerBean(beanName, CustomEntityManagerFactoryBean.class, () -> this.customEntityManagerFactoryBean(dbConfig, tenantId), new BeanDefinitionCustomizer[0]);
        return beanName;
    }

    public void createTables(String userName, DataSourceConfig dbConfig) {
        if (!userName.equalsIgnoreCase("public")) {
            String beanName = this.createBean(userName, dbConfig);
            CustomEntityManagerFactoryBean l = (CustomEntityManagerFactoryBean)((Object)this.beanFactory.getBean(CustomEntityManagerFactoryBean.class));
            this.context.removeBeanDefinition(beanName);
        }
    }

    CustomEntityManagerFactoryBean customEntityManagerFactoryBean(DataSourceConfig dbConfig, final String tenantId) {
        DataSourceBuilder factory = DataSourceBuilder.create().driverClassName(dbConfig.getDriverClassName()).username(dbConfig.getUsername()).password(dbConfig.getPassword()).url(dbConfig.getUrl());
        final DataSource dataSource_tenant = factory.build();
        AbstractDataSourceBasedMultiTenantConnectionProviderImpl multiTenantConnectionProvider = new AbstractDataSourceBasedMultiTenantConnectionProviderImpl(){

            protected DataSource selectAnyDataSource() {
                return this.selectDataSource(tenantId);
            }

            protected DataSource selectDataSource(String tenantIdentifier) {
                return dataSource_tenant;
            }
        };
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = this.persistenceJPAConfig.entityManagerFactory();
        CustomEntityManagerFactoryBean customEntityManagerFactoryBean = new CustomEntityManagerFactoryBean();
        Map jpaPropertyMap = localContainerEntityManagerFactoryBean.getJpaPropertyMap();
        if (Constants.strategy.equals((Object)StrategyType.SCHEMA)) {
            jpaPropertyMap.put("hibernate.default_schema", tenantId);
            customEntityManagerFactoryBean.setDataSource(this.dataSource);
        } else {
            if (!dbConfig.getGenerate().booleanValue()) {
                jpaPropertyMap.put("hibernate.connection.username", dbConfig.getUsername());
                jpaPropertyMap.put("hibernate.connection.password", dbConfig.getPassword());
                jpaPropertyMap.put("hibernate.connection.url", dbConfig.getUrl());
                jpaPropertyMap.put("hibernate.connection.driver_class", dbConfig.getDriverClassName());
            } else {
                try {
                    jpaPropertyMap.put("hibernate.connection.url", dbConfig.getUrl());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            jpaPropertyMap.put("hibernate.multi_tenant_connection_provider", multiTenantConnectionProvider);
            customEntityManagerFactoryBean.setDataSource(dataSource_tenant);
        }
        customEntityManagerFactoryBean.setJpaPropertyMap(jpaPropertyMap);
        customEntityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)new HibernateJpaVendorAdapter());
        customEntityManagerFactoryBean.setPackagesToScan(Constants.basePackages);
        return customEntityManagerFactoryBean;
    }

    private <T> T getValue(Object entity, String fieldName, Class<T> classType) {
        try {
            fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method methodId = entity.getClass().getSuperclass().getDeclaredMethod("get" + fieldName, new Class[0]);
            Object value = methodId.invoke(entity, new Object[0]);
            return (T)value;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private <T> void setValue(Object entity, String fieldName, Object value, Class<T> classType) {
        try {
            Field field = entity.getClass().getSuperclass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(entity, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public DBTenantHelper(DataSource dataSource, BeanFactory beanFactory, GenericWebApplicationContext context, JpaHibernateProperties jpaHibernateProperties, CurrentTenantIdentifierResolver currentTenantIdentifierResolver, Optional<TenantDataSource> optionalTenantDataSource, MultiTenantConnectionProvider multiTenantConnectionProvider) {
        this.dataSource = dataSource;
        this.beanFactory = beanFactory;
        this.context = context;
        this.jpaHibernateProperties = jpaHibernateProperties;
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
        this.optionalTenantDataSource = optionalTenantDataSource;
        this.multiTenantConnectionProvider = multiTenantConnectionProvider;
    }
}

