package io.gitlab.rujal_sh.db.config.domain;

import io.gitlab.rujal_sh.annotation.internal.DataSourceConfiguration;

import javax.persistence.CascadeType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;

@MappedSuperclass
public class DataSourceComponent {

    @OneToOne(cascade = CascadeType.ALL)
    @JoinColumn(name = "dataSourceConfig_Id")
    @DataSourceConfiguration
    private DataSourceConfig dataSourceConfig;

    public DataSourceConfig getDataSourceConfig() {
        return dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }
}
