package io.gitlab.rujal_sh.db.config;

import io.gitlab.rujal_sh.db.config.domain.DataSourceConfig;
import io.gitlab.rujal_sh.db.config.repo.DataSourceConfigRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.GenericWebApplicationContext;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//@Component
//@DependsOn("dataSourceConfigRepository")
public class TenantDataSource implements Serializable {

    private final GenericWebApplicationContext context;
    private final BeanFactory beanFactory;

    public static Map<String, DataSource> dataSources = new HashMap<>();

    public TenantDataSource(GenericWebApplicationContext context,
                            BeanFactory beanFactory){
        this.context = context;
        this.beanFactory = beanFactory;
//        JpaRepositoryFactoryBean repositoryFactoryBean = new JpaRepositoryFactoryBean(DataSourceConfigRepository.class);
//        context.registerBean("dataSourceConfigRepository", DataSourceConfigRepository.class, repositoryFactoryBean);
    }

    @RequiredArgsConstructor
    @Lazy
    private static class AssignTenantDataSource extends SqlExecutions {

        private final BeanFactory beanFactory;

        private DataSourceConfigRepository dataSourceConfigRepository;

        @PostConstruct
        private void getAll() {
            dataSourceConfigRepository = beanFactory.getBean(DataSourceConfigRepository.class);
            List<DataSourceConfig> configList = dataSourceConfigRepository.findAll();
            Map<String, DataSource> result = new HashMap<>();
            for (DataSourceConfig config : configList) {
                result.put(config.getName(), createDataSource(config));
            }
            TenantDataSource.dataSources = result;
        }
    }
}