package io.gitlab.rujal_sh.db.config;

import lombok.RequiredArgsConstructor;
import org.hibernate.engine.jdbc.connections.spi.AbstractDataSourceBasedMultiTenantConnectionProviderImpl;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.util.Map;

//@Component
@RequiredArgsConstructor
public class DataSourceBasedMultiTenantConnectionProviderImpl extends AbstractDataSourceBasedMultiTenantConnectionProviderImpl {

    private final DataSource defaultDS;
    private final TenantDataSource tenantDataSource;

    @Override
    protected DataSource selectAnyDataSource() {
        return defaultDS;
    }

    @Override
    protected DataSource selectDataSource(String tenantId) {
        if (!tenantId.equalsIgnoreCase("public")) {
            try {
                Map<String, DataSource> dataSourceMap = tenantDataSource.dataSources;
                return dataSourceMap.get(tenantId) != null ? dataSourceMap.get(tenantId) : defaultDS;
            }catch (Exception e){
                throw new RuntimeException("Access Denied");
            }
        }else{
            return defaultDS;
        }
    }



}