package io.gitlab.rujal_sh.commons;

import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.springframework.stereotype.Component;

//@Component
public class TenantSchemaResolver implements CurrentTenantIdentifierResolver {

    public static final String DEFAULT_TENANT ="public";

    @Override
    public String resolveCurrentTenantIdentifier() {
        String tenant =  TenantContext.getCurrentTenant();
        if(tenant != null){
            return tenant;
        } else {
            return DEFAULT_TENANT;
        }
    }

    @Override
    public boolean validateExistingCurrentSessions() {
        return true;
    }
}