package io.gitlab.rujal_sh.annotation;

import io.gitlab.rujal_sh.commons.JpaHibernateProperties;
import io.gitlab.rujal_sh.commons.PersistenceJPAConfig;
import io.gitlab.rujal_sh.commons.StaticResourceConfiguration;
import io.gitlab.rujal_sh.commons.TenantSchemaResolver;
import io.gitlab.rujal_sh.commons.interceptor.RequestInterceptor;
import io.gitlab.rujal_sh.commons.utils.Constants;
import io.gitlab.rujal_sh.db.config.DBTenantHelper;
import io.gitlab.rujal_sh.db.config.DataSourceBasedMultiTenantConnectionProviderImpl;
import io.gitlab.rujal_sh.db.config.TenantDataSource;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@AutoConfigurationPackage
@Import({RequestInterceptor.class,
        Constants.class,
        StaticResourceConfiguration.class,
        PersistenceJPAConfig.class,
        TenantSchemaResolver.class,
        DBTenantHelper.class,
        JpaHibernateProperties.class,
        DataSourceBasedMultiTenantConnectionProviderImpl.class,
        TenantDataSource.class})
public @interface Database_Based_MultiTenancy {

    String[] basePackages() default {};

}
