/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import org.silbertb.proto.domainconverter.StringUtils;
import org.silbertb.proto.domainconverter.conversion_data.FieldType;
import org.silbertb.proto.domainconverter.custom.ProtoType;

public class FieldData {
    private final FieldType fieldType;
    private final String protoFieldPascalCase;
    private final String domainFieldMethodSuffix;
    private final String dataStructureConcreteType;
    private final String converterName;
    private final String converterFullName;
    private final ProtoType protoTypeForConverter;

    public boolean hasConverter() {
        return this.converterName != null;
    }

    public FieldData(FieldType fieldType, String domainFieldName, String explicitProtoFieldName, String dataStructureConcreteType, String converterFullName, ProtoType protoTypeForConverter) {
        this.fieldType = fieldType;
        this.protoFieldPascalCase = FieldData.protoFieldPascalCase(domainFieldName, explicitProtoFieldName);
        this.domainFieldMethodSuffix = StringUtils.capitalize(domainFieldName);
        this.dataStructureConcreteType = dataStructureConcreteType;
        this.converterFullName = converterFullName;
        this.converterName = converterFullName == null ? null : StringUtils.getSimpleName(converterFullName);
        this.protoTypeForConverter = protoTypeForConverter;
    }

    private static String protoFieldPascalCase(String domainFieldName, String customProtoFieldName) {
        return customProtoFieldName.equals("") ? StringUtils.capitalize(domainFieldName) : StringUtils.snakeCaseToPascalCase(customProtoFieldName);
    }

    private String protoBuilderSetCommand() {
        switch (this.protoTypeForConverter) {
            case MAP: {
                return "putAll" + this.protoFieldPascalCase;
            }
            case LIST: {
                return "addAll" + this.protoFieldPascalCase;
            }
            case OTHER: {
                return "set" + this.protoFieldPascalCase;
            }
        }
        throw new RuntimeException("Unhandled proto type: " + this.fieldType);
    }

    private String domainGetterMethodPrefix() {
        if (this.fieldType.equals((Object)FieldType.BOOLEAN)) {
            return "is";
        }
        return "get";
    }

    public String domainGetterMethod() {
        return this.domainGetterMethodPrefix() + this.domainFieldMethodSuffix;
    }

    public String addToBuilderUsingConverter() {
        return "builder." + this.protoBuilderSetCommand() + "(converter.toProtobufValue(domain." + this.domainGetterMethod() + "()))";
    }

    private String protoGetterSuffix() {
        switch (this.protoTypeForConverter) {
            case LIST: {
                return "List";
            }
            case MAP: {
                return "Map";
            }
            case OTHER: {
                return "";
            }
        }
        throw new RuntimeException("Unhandled proto type: " + this.protoTypeForConverter);
    }

    public String protoGetterMethod() {
        return "get" + this.protoFieldPascalCase + this.protoGetterSuffix();
    }

    public String setInDomainUsingConverter() {
        return "domain.set" + this.domainFieldMethodSuffix + "(converter.toDomainValue(proto." + this.protoGetterMethod() + "()))";
    }

    public String checkNotNullCommand() {
        if (this.isNullableDomainType()) {
            return "if(domain.get" + this.domainFieldMethodSuffix + "() != null) {";
        }
        return "";
    }

    public String closeCheckNotNullCommand() {
        return this.isNullableDomainType() ? "}" : "";
    }

    private boolean isNullableDomainType() {
        switch (this.fieldType) {
            case MESSAGE: 
            case PRIMITIVE_LIST: 
            case MESSAGE_LIST: 
            case PRIMITIVE_MAP: 
            case MAP_TO_MESSAGE: 
            case STRING: 
            case BYTES: {
                return true;
            }
            case OTHER: 
            case BOOLEAN: {
                return false;
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public String addToBuilderCommand() {
        switch (this.fieldType) {
            case BOOLEAN: {
                return "builder.set" + this.protoFieldPascalCase + "(domain.is" + this.domainFieldMethodSuffix + "())";
            }
            case MESSAGE: {
                return "builder.set" + this.protoFieldPascalCase + "(toProto(domain.get" + this.domainFieldMethodSuffix + "()))";
            }
            case PRIMITIVE_LIST: {
                return "builder.addAll" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
            case MESSAGE_LIST: {
                return "domain.get" + this.domainFieldMethodSuffix + "().forEach(item -> builder.add" + this.protoFieldPascalCase + "(toProto(item)))";
            }
            case PRIMITIVE_MAP: {
                return "builder.putAll" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
            case MAP_TO_MESSAGE: {
                return "domain.get" + this.domainFieldMethodSuffix + "().forEach((key, value) -> builder.put" + this.protoFieldPascalCase + "(key, toProto(value)))";
            }
            case BYTES: {
                return "builder.set" + this.protoFieldPascalCase + "(ByteString.copyFrom(domain.get" + this.domainFieldMethodSuffix + "()))";
            }
            case STRING: 
            case OTHER: {
                return "builder.set" + this.protoFieldPascalCase + "(domain.get" + this.domainFieldMethodSuffix + "())";
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public String checkProtoHasValueCommand() {
        if (this.isNullableProtoType()) {
            return "if(proto.has" + this.protoFieldPascalCase + "()) {";
        }
        return "";
    }

    public String closeProtoHasValueCommand() {
        return this.isNullableProtoType() ? "}" : "";
    }

    public boolean isNullableProtoType() {
        return this.fieldType.equals((Object)FieldType.MESSAGE);
    }

    public String setInDomainCommand() {
        return "domain.set" + this.domainFieldMethodSuffix + "(" + this.convertProtoValue() + ")";
    }

    public String convertProtoValue() {
        switch (this.fieldType) {
            case STRING: 
            case OTHER: 
            case BOOLEAN: {
                return "proto.get" + this.protoFieldPascalCase + "()";
            }
            case PRIMITIVE_MAP: {
                return "new " + this.dataStructureConcreteType + "<>(proto.get" + this.protoFieldPascalCase + "())";
            }
            case MESSAGE: {
                return "toDomain(proto.get" + this.protoFieldPascalCase + "())";
            }
            case PRIMITIVE_LIST: {
                return "new " + this.dataStructureConcreteType + "<>(proto.get" + this.protoFieldPascalCase + "List())";
            }
            case MESSAGE_LIST: {
                return "proto.get" + this.protoFieldPascalCase + "List().stream().map(item -> toDomain(item)).collect(Collectors.toCollection(" + this.dataStructureConcreteType + "::new))";
            }
            case MAP_TO_MESSAGE: {
                return "proto.get" + this.protoFieldPascalCase + "Map().entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> toDomain(e.getValue()), (v1, v2) -> v1, " + this.dataStructureConcreteType + "::new))";
            }
            case BYTES: {
                return "proto.get" + this.protoFieldPascalCase + "().toByteArray()";
            }
        }
        throw new RuntimeException("Unhandled field type: " + this.fieldType);
    }

    public static FieldDataBuilder builder() {
        return new FieldDataBuilder();
    }

    public FieldType fieldType() {
        return this.fieldType;
    }

    public String protoFieldPascalCase() {
        return this.protoFieldPascalCase;
    }

    public String domainFieldMethodSuffix() {
        return this.domainFieldMethodSuffix;
    }

    public String dataStructureConcreteType() {
        return this.dataStructureConcreteType;
    }

    public String converterName() {
        return this.converterName;
    }

    public String converterFullName() {
        return this.converterFullName;
    }

    public ProtoType protoTypeForConverter() {
        return this.protoTypeForConverter;
    }

    public static class FieldDataBuilder {
        private FieldType fieldType;
        private String domainFieldName;
        private String explicitProtoFieldName;
        private String dataStructureConcreteType;
        private String converterFullName;
        private ProtoType protoTypeForConverter;

        FieldDataBuilder() {
        }

        public FieldDataBuilder fieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public FieldDataBuilder domainFieldName(String domainFieldName) {
            this.domainFieldName = domainFieldName;
            return this;
        }

        public FieldDataBuilder explicitProtoFieldName(String explicitProtoFieldName) {
            this.explicitProtoFieldName = explicitProtoFieldName;
            return this;
        }

        public FieldDataBuilder dataStructureConcreteType(String dataStructureConcreteType) {
            this.dataStructureConcreteType = dataStructureConcreteType;
            return this;
        }

        public FieldDataBuilder converterFullName(String converterFullName) {
            this.converterFullName = converterFullName;
            return this;
        }

        public FieldDataBuilder protoTypeForConverter(ProtoType protoTypeForConverter) {
            this.protoTypeForConverter = protoTypeForConverter;
            return this;
        }

        public FieldData build() {
            return new FieldData(this.fieldType, this.domainFieldName, this.explicitProtoFieldName, this.dataStructureConcreteType, this.converterFullName, this.protoTypeForConverter);
        }

        public String toString() {
            return "FieldData.FieldDataBuilder(fieldType=" + this.fieldType + ", domainFieldName=" + this.domainFieldName + ", explicitProtoFieldName=" + this.explicitProtoFieldName + ", dataStructureConcreteType=" + this.dataStructureConcreteType + ", converterFullName=" + this.converterFullName + ", protoTypeForConverter=" + this.protoTypeForConverter + ")";
        }
    }
}

