/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import java.util.List;
import org.silbertb.proto.domainconverter.StringUtils;
import org.silbertb.proto.domainconverter.conversion_data.ClassData;

public class ConversionData {
    private final String generator;
    private final String converterPackage;
    private final String converterClass;
    private final List<ClassData> classesData;

    public ConversionData(String generator, String converterFullName, List<ClassData> classesData) {
        this.generator = generator;
        this.converterPackage = StringUtils.getPackage(converterFullName);
        this.converterClass = StringUtils.getSimpleName(converterFullName);
        this.classesData = classesData;
    }

    public static ConversionDataBuilder builder() {
        return new ConversionDataBuilder();
    }

    public String generator() {
        return this.generator;
    }

    public String converterPackage() {
        return this.converterPackage;
    }

    public String converterClass() {
        return this.converterClass;
    }

    public List<ClassData> classesData() {
        return this.classesData;
    }

    public static class ConversionDataBuilder {
        private String generator;
        private String converterFullName;
        private List<ClassData> classesData;

        ConversionDataBuilder() {
        }

        public ConversionDataBuilder generator(String generator) {
            this.generator = generator;
            return this;
        }

        public ConversionDataBuilder converterFullName(String converterFullName) {
            this.converterFullName = converterFullName;
            return this;
        }

        public ConversionDataBuilder classesData(List<ClassData> classesData) {
            this.classesData = classesData;
            return this;
        }

        public ConversionData build() {
            return new ConversionData(this.generator, this.converterFullName, this.classesData);
        }

        public String toString() {
            return "ConversionData.ConversionDataBuilder(generator=" + this.generator + ", converterFullName=" + this.converterFullName + ", classesData=" + this.classesData + ")";
        }
    }
}

