/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter.conversion_data;

import java.util.List;
import org.silbertb.proto.domainconverter.StringUtils;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseClassData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseFieldData;
import org.silbertb.proto.domainconverter.conversion_data.ParameterData;

public class ClassData {
    private final String domainFullName;
    private final String domainClass;
    private final String protoFullName;
    private final String protoClass;
    private final String mapperClass;
    private final String mapperFullName;
    private final OneofBaseClassData oneofBaseClassData;
    private final List<FieldData> fieldsData;
    private final List<OneofBaseFieldData> oneofBaseFieldsData;
    private final List<ParameterData> constructorParameters;

    public ClassData(String domainFullName, String protoFullName, String mapperFullName, OneofBaseClassData oneofBaseClassData, List<FieldData> fieldsData, List<OneofBaseFieldData> oneofBaseFieldsData, List<ParameterData> constructorParameters) {
        this.domainFullName = domainFullName;
        this.protoFullName = protoFullName;
        this.mapperFullName = mapperFullName;
        this.oneofBaseClassData = oneofBaseClassData;
        this.fieldsData = fieldsData;
        this.oneofBaseFieldsData = oneofBaseFieldsData;
        this.constructorParameters = constructorParameters;
        this.domainClass = StringUtils.getSimpleName(domainFullName);
        this.protoClass = StringUtils.getSimpleName(protoFullName);
        this.mapperClass = mapperFullName == null ? null : StringUtils.getSimpleName(mapperFullName);
    }

    public boolean hasMapper() {
        return this.mapperClass != null;
    }

    public static ClassDataBuilder builder() {
        return new ClassDataBuilder();
    }

    public String domainFullName() {
        return this.domainFullName;
    }

    public String domainClass() {
        return this.domainClass;
    }

    public String protoFullName() {
        return this.protoFullName;
    }

    public String protoClass() {
        return this.protoClass;
    }

    public String mapperClass() {
        return this.mapperClass;
    }

    public String mapperFullName() {
        return this.mapperFullName;
    }

    public OneofBaseClassData oneofBaseClassData() {
        return this.oneofBaseClassData;
    }

    public List<FieldData> fieldsData() {
        return this.fieldsData;
    }

    public List<OneofBaseFieldData> oneofBaseFieldsData() {
        return this.oneofBaseFieldsData;
    }

    public List<ParameterData> constructorParameters() {
        return this.constructorParameters;
    }

    public static class ClassDataBuilder {
        private String domainFullName;
        private String protoFullName;
        private String mapperFullName;
        private OneofBaseClassData oneofBaseClassData;
        private List<FieldData> fieldsData;
        private List<OneofBaseFieldData> oneofBaseFieldsData;
        private List<ParameterData> constructorParameters;

        ClassDataBuilder() {
        }

        public ClassDataBuilder domainFullName(String domainFullName) {
            this.domainFullName = domainFullName;
            return this;
        }

        public ClassDataBuilder protoFullName(String protoFullName) {
            this.protoFullName = protoFullName;
            return this;
        }

        public ClassDataBuilder mapperFullName(String mapperFullName) {
            this.mapperFullName = mapperFullName;
            return this;
        }

        public ClassDataBuilder oneofBaseClassData(OneofBaseClassData oneofBaseClassData) {
            this.oneofBaseClassData = oneofBaseClassData;
            return this;
        }

        public ClassDataBuilder fieldsData(List<FieldData> fieldsData) {
            this.fieldsData = fieldsData;
            return this;
        }

        public ClassDataBuilder oneofBaseFieldsData(List<OneofBaseFieldData> oneofBaseFieldsData) {
            this.oneofBaseFieldsData = oneofBaseFieldsData;
            return this;
        }

        public ClassDataBuilder constructorParameters(List<ParameterData> constructorParameters) {
            this.constructorParameters = constructorParameters;
            return this;
        }

        public ClassData build() {
            return new ClassData(this.domainFullName, this.protoFullName, this.mapperFullName, this.oneofBaseClassData, this.fieldsData, this.oneofBaseFieldsData, this.constructorParameters);
        }

        public String toString() {
            return "ClassData.ClassDataBuilder(domainFullName=" + this.domainFullName + ", protoFullName=" + this.protoFullName + ", mapperFullName=" + this.mapperFullName + ", oneofBaseClassData=" + this.oneofBaseClassData + ", fieldsData=" + this.fieldsData + ", oneofBaseFieldsData=" + this.oneofBaseFieldsData + ", constructorParameters=" + this.constructorParameters + ")";
        }
    }
}

