/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter;

import java.util.Arrays;
import java.util.stream.Collectors;

public class StringUtils {
    public static String snakeCaseToPascalCase(String str) {
        return Arrays.stream(str.split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining());
    }

    public static String pascalCaseToSnakeCase(String str) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        str = str.replaceAll(regex, replacement).toLowerCase();
        return str;
    }

    public static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String getPackage(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return classFullName.substring(0, index);
    }

    public static String getSimpleName(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return classFullName.substring(index + 1);
    }

    public static String pascalCaseToCamelCase(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }
}

