/*
 * Decompiled with CFR 0.152.
 */
package org.silbertb.proto.domainconverter;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.silbertb.proto.domainconverter.LangModelUtil;
import org.silbertb.proto.domainconverter.StringUtils;
import org.silbertb.proto.domainconverter.annotations.OneofBase;
import org.silbertb.proto.domainconverter.annotations.OneofField;
import org.silbertb.proto.domainconverter.annotations.ProtoClass;
import org.silbertb.proto.domainconverter.annotations.ProtoConstructor;
import org.silbertb.proto.domainconverter.annotations.ProtoConverter;
import org.silbertb.proto.domainconverter.annotations.ProtoField;
import org.silbertb.proto.domainconverter.conversion_data.ClassData;
import org.silbertb.proto.domainconverter.conversion_data.ConversionData;
import org.silbertb.proto.domainconverter.conversion_data.FieldData;
import org.silbertb.proto.domainconverter.conversion_data.FieldType;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseClassData;
import org.silbertb.proto.domainconverter.conversion_data.OneofBaseFieldData;
import org.silbertb.proto.domainconverter.conversion_data.OneofFieldData;
import org.silbertb.proto.domainconverter.conversion_data.ParameterData;
import org.silbertb.proto.domainconverter.custom.NullMapper;

@SupportedAnnotationTypes(value={"org.silbertb.proto.domainconverter.annotations.ProtoClass"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConverterGenerator
extends AbstractProcessor {
    private LangModelUtil langModelUtil;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.langModelUtil = new LangModelUtil(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConversionData conversionData = this.createConversionData(annotations, roundEnv);
        if (conversionData.classesData().isEmpty()) {
            return true;
        }
        try {
            this.writeSource(conversionData);
        }
        catch (IOException ex) {
            this.error("Failed to generate proto domain conversion class. Exception: " + ex);
        }
        return true;
    }

    private void writeSource(ConversionData conversionData) throws IOException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache m = mf.compile("converter.mustache");
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject fileObject = filer.createSourceFile(conversionData.converterPackage() + "." + conversionData.converterClass(), new Element[0]);
        try (PrintWriter out = new PrintWriter(fileObject.openWriter());){
            m.execute((Writer)out, (Object)conversionData);
            out.flush();
        }
    }

    private ConversionData createConversionData(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String converterName = this.processingEnv.getOptions().get("proto.domain.converter.name");
        if (converterName == null) {
            converterName = "org.silbertb.proto.domainconverter.generated.ProtoDomainConverter";
        }
        ConversionData.ConversionDataBuilder conversionData = ConversionData.builder().generator(this.getClass().getName()).converterFullName(converterName);
        ArrayList<ClassData> classesData = new ArrayList<ClassData>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                ClassData classData = this.createClassData((TypeElement)element);
                classesData.add(classData);
            }
        }
        return conversionData.classesData(classesData).build();
    }

    private ClassData createClassData(TypeElement domainElement) {
        ProtoClass protoClassAnnotation = domainElement.getAnnotation(ProtoClass.class);
        TypeMirror protoClass = this.langModelUtil.getClassFromAnnotation(protoClassAnnotation::protoClass);
        ClassData.ClassDataBuilder classData = ClassData.builder().domainFullName(domainElement.getQualifiedName().toString()).protoFullName(protoClass.toString());
        TypeMirror mapperClass = this.langModelUtil.getClassFromAnnotation(protoClassAnnotation::mapper);
        String mapperFullName = mapperClass.toString();
        if (!mapperFullName.equals(NullMapper.class.getName())) {
            return classData.mapperFullName(mapperFullName).constructorParameters(Collections.emptyList()).fieldsData(Collections.emptyList()).oneofBaseFieldsData(Collections.emptyList()).build();
        }
        classData.constructorParameters(this.getConstructorParametersData(domainElement));
        ArrayList<FieldData> fieldDataList = new ArrayList<FieldData>();
        ArrayList<OneofBaseFieldData> oneofBaseFieldsDataList = new ArrayList<OneofBaseFieldData>();
        for (Element field : this.getDomainFields(domainElement, protoClassAnnotation.withInheritedFields())) {
            OneofBaseFieldData oneofBaseFieldData;
            FieldData fieldData = this.createFieldData((VariableElement)field);
            if (fieldData != null) {
                fieldDataList.add(fieldData);
            }
            if ((oneofBaseFieldData = this.createOneofBaseFieldData((VariableElement)field)) != null) {
                oneofBaseFieldsDataList.add(oneofBaseFieldData);
            }
            if (fieldData == null || oneofBaseFieldData == null) continue;
            throw new IllegalArgumentException("field is annotated with both 'ProtoField' and 'OneofField'. field: " + field);
        }
        classData.fieldsData(fieldDataList).oneofBaseFieldsData(oneofBaseFieldsDataList);
        OneofBase oneofBaseAnnotation = domainElement.getAnnotation(OneofBase.class);
        classData.oneofBaseClassData(this.createOneofBaseClassData(oneofBaseAnnotation));
        return classData.build();
    }

    private List<ParameterData> getConstructorParametersData(TypeElement domainElement) {
        ArrayList<ParameterData> constructorParameters = new ArrayList<ParameterData>();
        List constructors = domainElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.CONSTRUCTOR) && e.getModifiers().contains((Object)Modifier.PUBLIC)).collect(Collectors.toList());
        for (Element constructor : constructors) {
            ProtoConstructor protoConstructorAnnotation = constructor.getAnnotation(ProtoConstructor.class);
            if (protoConstructorAnnotation == null) continue;
            if (!constructorParameters.isEmpty()) {
                throw new IllegalArgumentException("More than one constructors are annotated with @ProtoConstructor. class: " + domainElement);
            }
            for (VariableElement variableElement : ((ExecutableElement)constructor).getParameters()) {
                OneofBaseFieldData oneofBaseFieldData;
                FieldData fieldData = this.createFieldData(variableElement);
                if (fieldData != null) {
                    ParameterData parameterData = ParameterData.builder().fieldData(fieldData).build();
                    constructorParameters.add(parameterData);
                }
                if ((oneofBaseFieldData = this.createOneofBaseFieldData(variableElement)) != null) {
                    ParameterData parameterData = ParameterData.builder().oneofFieldData(oneofBaseFieldData).build();
                    constructorParameters.add(parameterData);
                }
                if (fieldData != null && oneofBaseFieldData != null) {
                    throw new IllegalArgumentException("constructor parameter is annotated with both 'ProtoField' and 'OneofField'. param: " + variableElement);
                }
                if (fieldData != null || oneofBaseFieldData != null) continue;
                throw new IllegalArgumentException("constructor parameter is not annotated with either 'ProtoField' and 'OneofField'. param: " + variableElement);
            }
            if (constructorParameters.size() <= 0) continue;
            ParameterData lastElement = (ParameterData)constructorParameters.get(constructorParameters.size() - 1);
            ParameterData parameterData = ParameterData.builder().fieldData(lastElement.fieldData()).oneofFieldData(lastElement.oneofFieldData()).isLast(true).build();
            constructorParameters.set(constructorParameters.size() - 1, parameterData);
        }
        return constructorParameters;
    }

    private OneofBaseClassData createOneofBaseClassData(OneofBase oneofBaseAnnotation) {
        if (oneofBaseAnnotation == null) {
            return null;
        }
        OneofBaseClassData oneofBaseClassData = new OneofBaseClassData(StringUtils.snakeCaseToPascalCase(oneofBaseAnnotation.oneofName()), this.createOneofFieldDataList(oneofBaseAnnotation, null));
        return oneofBaseClassData;
    }

    private OneofBaseFieldData createOneofBaseFieldData(VariableElement field) {
        OneofBase oneofBaseAnnotation = field.getAnnotation(OneofBase.class);
        if (oneofBaseAnnotation == null) {
            return null;
        }
        String oneofBaseField = StringUtils.capitalize(field.getSimpleName().toString());
        OneofBaseFieldData.OneofBaseFieldDataBuilder oneofBaseFieldData = OneofBaseFieldData.builder();
        oneofBaseFieldData.oneofProtoName(oneofBaseAnnotation.oneofName().equals("") ? StringUtils.capitalize(field.getSimpleName().toString()) : StringUtils.snakeCaseToPascalCase(oneofBaseAnnotation.oneofName())).oneofBaseField(oneofBaseField).oneOfFieldsData(this.createOneofFieldDataList(oneofBaseAnnotation, oneofBaseField)).domainFieldType(field.asType().toString());
        return oneofBaseFieldData.build();
    }

    private List<OneofFieldData> createOneofFieldDataList(OneofBase oneofBaseAnnotation, String oneofBaseField) {
        ArrayList<OneofFieldData> oneOfFieldsData = new ArrayList<OneofFieldData>();
        for (OneofField oneofFieldAnnotation : oneofBaseAnnotation.oneOfFields()) {
            OneofFieldData oneofFieldData = this.createOneofFieldData(oneofFieldAnnotation, oneofBaseField);
            oneOfFieldsData.add(oneofFieldData);
        }
        return oneOfFieldsData;
    }

    private OneofFieldData createOneofFieldData(OneofField oneofFieldAnnotation, String oneofBaseField) {
        TypeMirror domainType = this.langModelUtil.getDomainClassFromAnnotation(oneofFieldAnnotation);
        return OneofFieldData.builder().oneofFieldCase(oneofFieldAnnotation.protoField().toUpperCase()).oneOfDomainField(StringUtils.capitalize(oneofFieldAnnotation.domainField())).oneOfProtoField(StringUtils.snakeCaseToPascalCase(oneofFieldAnnotation.protoField())).oneofImplClass(domainType.toString()).oneofImplClassSimple(((DeclaredType)domainType).asElement().getSimpleName().toString()).fieldIsMessage(this.isProtoMessage(this.processingEnv.getElementUtils().getTypeElement(domainType.toString()).asType())).domainBaseField(oneofBaseField).build();
    }

    private FieldData createFieldData(VariableElement field) {
        ProtoField protoFieldAnnotation = field.getAnnotation(ProtoField.class);
        if (protoFieldAnnotation == null) {
            return null;
        }
        TypeMirror fieldType = field.asType();
        FieldData.FieldDataBuilder fieldData = FieldData.builder();
        fieldData.domainFieldName(field.getSimpleName().toString()).explicitProtoFieldName(protoFieldAnnotation.protoName()).fieldType(this.calculateFieldType(fieldType)).dataStructureConcreteType(this.calculateDataStructureConcreteType(field));
        ProtoConverter protoConverterAnnotation = field.getAnnotation(ProtoConverter.class);
        if (protoConverterAnnotation != null) {
            TypeMirror converterType = this.langModelUtil.getClassFromAnnotation(() -> protoConverterAnnotation.converter());
            fieldData.protoTypeForConverter(protoConverterAnnotation.protoType()).converterFullName(converterType.toString());
        }
        return fieldData.build();
    }

    private String calculateDataStructureConcreteType(VariableElement field) {
        TypeMirror fieldType = field.asType();
        if (this.langModelUtil.isList(fieldType)) {
            if (this.langModelUtil.isConcreteType(field)) {
                return this.processingEnv.getTypeUtils().erasure(fieldType).toString();
            }
            return ArrayList.class.getName();
        }
        if (this.langModelUtil.isMap(fieldType)) {
            if (this.langModelUtil.isConcreteType(field)) {
                return this.processingEnv.getTypeUtils().erasure(fieldType).toString();
            }
            if (this.langModelUtil.isAssignedFrom(fieldType, SortedMap.class)) {
                return TreeMap.class.getName();
            }
            return HashMap.class.getName();
        }
        return null;
    }

    private FieldType calculateFieldType(TypeMirror fieldType) {
        if (fieldType.getKind().equals((Object)TypeKind.BOOLEAN)) {
            return FieldType.BOOLEAN;
        }
        if (this.langModelUtil.isSameType(fieldType, String.class)) {
            return FieldType.STRING;
        }
        if (this.langModelUtil.isByteArray(fieldType)) {
            return FieldType.BYTES;
        }
        if (this.isProtoMessage(fieldType)) {
            return FieldType.MESSAGE;
        }
        if (this.langModelUtil.isList(fieldType)) {
            TypeMirror typeArgument = this.langModelUtil.getGenericsTypes(fieldType).get(0);
            if (this.isProtoMessage(typeArgument)) {
                return FieldType.MESSAGE_LIST;
            }
            return FieldType.PRIMITIVE_LIST;
        }
        if (this.langModelUtil.isMap(fieldType)) {
            TypeMirror typeArgument = this.langModelUtil.getGenericsTypes(fieldType).get(1);
            if (this.isProtoMessage(typeArgument)) {
                return FieldType.MAP_TO_MESSAGE;
            }
            return FieldType.PRIMITIVE_MAP;
        }
        return FieldType.OTHER;
    }

    private boolean isProtoMessage(TypeMirror fieldType) {
        if (fieldType.getKind().equals((Object)TypeKind.DECLARED)) {
            return this.langModelUtil.getAnnotation(fieldType, ProtoClass.class) != null;
        }
        return false;
    }

    private List<Element> getDomainFields(TypeElement domainElement, boolean withInheritedFields) {
        List<Element> fields = domainElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).collect(Collectors.toList());
        if (withInheritedFields && domainElement.getSuperclass().getKind() == TypeKind.DECLARED) {
            TypeElement superclass = (TypeElement)this.processingEnv.getTypeUtils().asElement(domainElement.getSuperclass());
            fields.addAll(this.getDomainFields(superclass, true));
        }
        return fields;
    }

    private void info(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }
}

