package org.silbertb.proto.domainconverter.conversion_data;

import lombok.Builder;
import lombok.Getter;
import lombok.experimental.Accessors;
import org.silbertb.proto.domainconverter.StringUtils;

@Accessors(fluent = true)
@Getter
@Builder
public class OneofFieldData {
    final private boolean fieldIsMessage;
    final private String oneofFieldCase;
    final private String domainBaseField;
    final private String oneofImplClass;
    final private String oneofImplClassSimple;
    final private String oneOfProtoField;
    final private String oneOfDomainField;

    public String addToBuilderCommand() {
        if(domainBaseField == null) { //class inheritance
            if(fieldIsMessage) {
                return "builder.set" + oneOfProtoField + "(toProto((" + oneofImplClass + ")domain))";
            }

            return "builder.set" + oneOfProtoField + "(((" + oneofImplClass + ")domain).get" + oneOfDomainField + "())";
        }

        //field inheritance
        if(fieldIsMessage) {
            return "builder.set" + oneOfProtoField + "(toProto((" + oneofImplClass + ")domain.get" + domainBaseField + "()))";
        }

        return "builder.set" + oneOfProtoField + "(((" + oneofImplClass + ")domain.get" + domainBaseField + "()).get" + oneOfDomainField + "())";
    }

    public String oneofImplVariable() {
        return StringUtils.pascalCaseToCamelCase(oneofImplClassSimple);
    }

    public String oneofImplCreation() {
        if(fieldIsMessage) {
            return "toDomain(proto.get" + oneOfProtoField + "())";
        }

        return "new " + oneofImplClass + "()";
    }

    public String setValueToVariable() {
        if(fieldIsMessage) {
            return "";
        }

        return oneofImplVariable() + ".set" + oneOfDomainField + "(proto.get" + oneOfProtoField + "());";
    }
}
