package org.silbertb.proto.domainconverter.annotations;

import org.silbertb.proto.domainconverter.custom.Mapper;
import org.silbertb.proto.domainconverter.custom.NullMapper;
import com.google.protobuf.Message;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Map between a domain class to a protobuf generated class.
 * The annotated class is the domain class
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
public @interface ProtoClass {
    /**
     *
     * @return The class generated from the protobuf message
     */
    Class<? extends Message> protoClass();

    /**
     * By default use other annotations for mapping, for example {@link ProtoField}
     * If return a mapper then the mapper is responsible for the conversion between the domain class and the protobuf generated class
     * @return mapper better domain class and protobuf generated class
     */
    Class<? extends Mapper> mapper() default NullMapper.class;

    /**
     * Consider annotated fields in super classes as well.
     * The default is false.
     * @return If true then annotated field in super classes will be considered.
     */
    boolean withInheritedFields() default false;
}
