package io.gitlab.pixelGraphics.twoDimGraphics

import cairo.*
import io.gitlab.pixelGraphics.twoDimGraphics.surface.Surface
import kotlinx.cinterop.*

public actual fun statusCodeToString(statusCode: UInt): String = cairo_status_to_string(statusCode)?.toKString() ?: ""

public actual fun surfaceStatusCode(surface: Surface): UInt = cairo_surface_status(surface.surfacePtr)

/**
 * Used to retrieve the list of supported versions.
 * @return An Array of supported PDF versions.
 */
public fun fetchSupportedVersions(): Array<_cairo_pdf_version> = memScoped {
    val versions = alloc<CPointerVar<cairo_pdf_version_tVar>>()
    val length = alloc<IntVar>()
    val tmpList = mutableListOf<_cairo_pdf_version>()
    cairo_pdf_get_versions(versions.ptr, length.ptr)
    var pos = 0
    do {
        val tmpItem = versions.value?.get(0)?.value
        if (tmpItem != null) tmpList += tmpItem
        pos++
    } while (tmpItem != null)
    return tmpList.toTypedArray()
}

/**
 * Gets the [String] representation of the given [version ID][version]. This function will return *""* (an empty
 * [String]) if [version] isn't valid.
 * @param version A version ID.
 * @return The [String] associated with the given [version].
 */
public fun pdfVersionToString(version: _cairo_pdf_version): String =
    cairo_pdf_version_to_string(version)?.toKString() ?: ""
