package com.tunetalk.ttdealersdk.activity;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import com.tunetalk.ttdealersdk.R;
import com.tunetalk.ttdealersdk.enums.ServiceCategories;
import com.tunetalk.ttdealersdk.ocr.DocumentType;
import com.tunetalk.ttdealersdk.singleton.DocumentIntentManager;
import com.tunetalk.ttdealersdk.util.ActivityUtils;
import com.tunetalk.ttdealersdk.util.Constant;
import com.tunetalk.ttdealersdk.util.Permissions;

public class PermissionActivity extends AppCompatActivity {
    String[] mScanOptions, nricScanOptions;
    Intent mServiceIntent;
    String apiKey, iccid;
    ServiceCategories mServiceCategory;
//    public static CardReader cardReaderHelper;
    public static boolean usbAttached = false;
    public static AlertDialog dialog;
    boolean isPortIn = false;

    @Override
    protected void onCreate (Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_permissions);

        if (Build.VERSION.SDK_INT == 26) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
        } else {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }

        apiKey = getIntent().getStringExtra(Constant.Key.Intent.API_KEY);
        iccid = getIntent().getStringExtra(Constant.Key.Intent.ICCID);
        mServiceCategory = DocumentIntentManager.init().getIntentEntity().getServiceCategories();

        checkPermissions();
//        initialiseCardReader();
    }

    private void checkPermissions ()
    {
        if (Build.VERSION.SDK_INT >= 23)
        {
            if (Permissions.hasPermission(PermissionActivity.this, Permissions.CAMERA,
                Permissions.STORAGE_READ, Permissions.STORAGE_WRITE))
            {
                proceedService();
            }
            else
                requestPermissions(new String[] {Permissions.CAMERA, Permissions.STORAGE_READ,
                    Permissions.STORAGE_WRITE}, Permissions.CAMERA_PERMISSION_CODE);
        }
        else
        {
            proceedService();
        }
    }


//    private void initialiseCardReader() {
//        cardReaderHelper = new CardReader(PermissionActivity.this);
//        IntentFilter filter = new IntentFilter();
//        filter.addAction(cardReaderHelper.ACTION_USB_PERMISSION);
//        filter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
//        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
//        registerReceiver(cardReaderHelper.mReceiver, filter);
//    }


    private void proceedService() {
        if (mServiceCategory != null) {
            if (mServiceCategory.equals(ServiceCategories.SIM_REG_AUTO)) {
                mServiceIntent = new Intent(this, SIMRegistrationAutoActivity.class);
                mScanOptions = getResources().getStringArray(R.array.ocr_registration_type);
            }
            else if (mServiceCategory.equals(ServiceCategories.SIM_REPLACEMENT_AUTO))
            {
                mServiceIntent = new Intent(this, SIMReplacementAutoActivity.class);
                mScanOptions = getResources().getStringArray(R.array.ocr_registration_type);
            }
            else if (mServiceCategory.equals(ServiceCategories.PORT_IN_AUTO))
            {
                isPortIn = true;
                mServiceIntent = new Intent(this, PortInAutoActivity.class);
                mScanOptions = getResources().getStringArray(R.array.ocr_document_type);
            }

//            nricScanOptions = getResources().getStringArray(R.array.scan_ic_options);

            new AlertDialog.Builder(this, R.style.DialogStyle)
                .setTitle(R.string.ocr_select_document)
                    .setSingleChoiceItems(mScanOptions, -1, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, final int scanDocumentType) {
                            if (isPortIn){
                                setDocumentTypePortIn(scanDocumentType);
                            } else {
                                setDocumentType(scanDocumentType);
                            }
                            mServiceIntent.putExtra("Mode", scanDocumentType);
                            startActivityForResult(mServiceIntent, Constant.RequestCode.SCAN_DOCUMENT_REQUEST_CODE);
                            dialog.dismiss();

//                            if (scanDocumentType == 0) {
//
//                                new AlertDialog.Builder(PermissionActivity.this, R.style.DialogStyle)
//                                        .setTitle(R.string.nric_select_option)
//                                        .setSingleChoiceItems(
//                                                nricScanOptions,
//                                                -1,
//                                                new DialogInterface.OnClickListener() {
//                                                    @Override
//                                                    public void onClick(DialogInterface dialog, int nricInputMode) {
//                                                        dialog.dismiss();
//
//                                                        if (nricInputMode == 0) {
//                                                            checkUsbConnection(mServiceIntent);
//                                                        } else {
//                                                            startActivityForResult(mServiceIntent, Constant.RequestCode.SCAN_DOCUMENT_REQUEST_CODE);
//                                                        }
//                                                    }
//                                                }
//                                        ).setNegativeButton(getString(R.string.common_text_back), new DialogInterface.OnClickListener() {
//                                    @Override
//                                    public void onClick(DialogInterface dialog, int which) {
//                                        dialog.dismiss();
//                                        ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED, null, getString(R.string.action_user_cancel));
//                                    }
//                                })
//                                        .setOnCancelListener(new DialogInterface.OnCancelListener() {
//                                            @Override
//                                            public void onCancel(DialogInterface dialogInterface) {
//                                                ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED, null, getString(R.string.action_user_cancel));
//                                            }
//                                        })
//                                        .show();
//                            } else {
//                                startActivityForResult(mServiceIntent, Constant.RequestCode.SCAN_DOCUMENT_REQUEST_CODE);
//                            }
                        }
                    })
                    .setNegativeButton(getString(R.string.common_text_back), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED, null,getString(R.string.action_user_cancel));
                    }
                })
                    .setOnCancelListener(new DialogInterface.OnCancelListener() {
                        @Override
                        public void onCancel(DialogInterface dialogInterface) {
                        ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED,null, getString(R.string.action_user_cancel));
                    }
                })
                .show();
        }
    }

    private void setDocumentType (int position)
    {
        switch (position){
            case 0:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.MYKAD);
                break;
            case 1:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.PASSPORT);
                break;
            case 2:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.IKAD);
                break;
            case 3:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.ARMY_ID);
                break;
            case 4:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.MYPR);
                break;
            case 5:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.IMM13);
                break;
            default:
                break;

        }
    }

    private void setDocumentTypePortIn (int position)
    {
        switch (position){
            case 0:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.MYKAD);
                break;
            case 1:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.PASSPORT);
                break;
            case 2:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.IKAD);
                break;
            case 3:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.MYPR);
                break;
            case 4:
                DocumentIntentManager.init().getIntentEntity().setDocumentType(DocumentType.IMM13);
                break;
            default:
                break;

        }
    }


//    private void checkUsbConnection(final Intent i) {
//        if (usbAttached) {
//
//            final AlertDialog insertKadDialog = new AlertDialog.Builder(PermissionActivity.this)
//                    .setTitle(R.string.insert_mykad)
//                    .setPositiveButton(R.string.btn_cancel, new DialogInterface.OnClickListener() {
//                        @Override
//                        public void onClick(DialogInterface dialog, int which) {
//                            dialog.dismiss();
//                        }
//                    }).show();
//
//            insertKadDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
//                @Override
//                public void onDismiss(DialogInterface dialog) {
//                    ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED, null, getString(R.string.action_user_cancel));
//                }
//            });
//
//            cardReaderCallback(insertKadDialog, i);
//
//        } else {
//            showCardReaderDialog(i);
//        }
//
//    }
//
//    public void showCardReaderDialog(final Intent i) {
//        CardReader.dialogopen = true;
//        dialog = new AlertDialog.Builder(PermissionActivity.this)
//                .setTitle(R.string.mykad_reader)
//                .setMessage(R.string.insert_card_reader)
//                .setPositiveButton(R.string.btn_cancel, new DialogInterface.OnClickListener() {
//                    @Override
//                    public void onClick(DialogInterface dialog, int which) {
//                        dialog.dismiss();
//                    }
//                }).show();
//
//        dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
//            @Override
//            public void onDismiss(DialogInterface dialog) {
//
//                if (usbAttached) {
//                    final AlertDialog insertKadDialog = new AlertDialog.Builder(PermissionActivity.this)
//                            .setTitle(R.string.insert_mykad)
//                            .setPositiveButton(R.string.btn_cancel, new DialogInterface.OnClickListener() {
//                                @Override
//                                public void onClick(DialogInterface dialog, int which) {
//                                    dialog.dismiss();
//                                }
//                            }).show();
//
//                    cardReaderCallback(insertKadDialog, i);
//                } else {
//                    dialog.dismiss();
//                    ActivityUtils.result(PermissionActivity.this, Constant.ResultCode.USER_CANCELLED, null, getString(R.string.action_user_cancel));
//                }
//            }
//        });
//    }
//
//    private void cardReaderCallback(final AlertDialog dialog, final Intent intent) {
//        cardReaderHelper.setActionCallback(new AsyncCallbackListener<ScanResultItemEntity>() {
//            @Override
//            public void onActionCallback(ScanResultItemEntity itemEntity) {
//                Log.d("CARD READER", "Read " + itemEntity.getNric());
//                dialog.dismiss();
//                DocumentIntentManager.init().getIntentEntity().setScanResultItemEntity(itemEntity);
//                mServiceIntent.putExtra("useCardReader", true);
//                startActivity(intent);
//            }
//        });
//    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (Permissions.hasPermission(this, Permissions.CAMERA, Permissions.STORAGE_READ, Permissions.STORAGE_WRITE))
        {
            proceedService();
        }
        else
        {
            new AlertDialog.Builder(this, R.style.DialogStyle)
                .setMessage("Tunetalk Dealer required number of permission in order to work properly.")
                .setTitle("Request Permission")
                    .setPositiveButton(getString(R.string.btn_ok), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                        finish();
                        dialog.dismiss();
                    }
                })
                    .setOnCancelListener(new DialogInterface.OnCancelListener() {
                        @Override
                        public void onCancel(DialogInterface dialogInterface) {
                        finish();
                    }
                })
                .show();

        }
    }

    @Override protected void onActivityResult (int requestCode, int resultCode, @Nullable Intent data)
    {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == Constant.RequestCode.SCAN_DOCUMENT_REQUEST_CODE)
        {
            switch (resultCode)
            {
                case Constant.ResultCode.USER_CANCELLED:
                    ActivityUtils.result(this, Constant.ResultCode.USER_CANCELLED, null,getString(R.string.action_user_cancel));
                    break;
                case Constant.ResultCode.SUCCESSFUL:
                case Constant.ResultCode.FAILED:
                case Constant.ResultCode.OFFLINE_SERVICE:
                    setResult(resultCode, data);
                    finish();
                    break;
                default:
                    break;
            }
        }
    }

    @Override public void onBackPressed ()
    {
        super.onBackPressed();
        finish();
    }

    @Override protected void onDestroy ()
    {
        super.onDestroy();

//        if (cardReaderHelper != null) {
//            try {
//                unregisterReceiver(cardReaderHelper.mReceiver);
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }

        DocumentIntentManager.reset();
    }
}
