//package com.tunetalk.ttdealersdk.util;
//
//import android.app.Activity;
//import android.app.PendingIntent;
//import android.app.ProgressDialog;
//import android.content.BroadcastReceiver;
//import android.content.Context;
//import android.content.Intent;
//import android.hardware.usb.UsbDevice;
//import android.hardware.usb.UsbManager;
//import android.os.AsyncTask;
//import android.util.Log;
//import android.widget.Toast;
//
//import com.acs.smartcard.Reader;
//import com.tunetalk.ttdealersdk.activity.PermissionActivity;
//import com.tunetalk.ttdealersdk.base.BaseActivity;
//import com.tunetalk.ttdealersdk.mykadreader.AsyncCallbackListener;
//import com.tunetalk.ttdealersdk.mykadreader.entity.APDU;
//import com.tunetalk.ttdealersdk.mykadreader.entity.JPNEntity;
//import com.tunetalk.ttdealersdk.ocr.DocumentType;
//import com.tunetalk.ttdealersdk.ocr.entity.ScanResultItemEntity;
//import com.tunetalk.ttdealersdk.singleton.DocumentIntentManager;
//
//public class CardReader extends BaseActivity {
//
//    private UsbManager mUsbManager;
//    private PendingIntent mPermissionIntent;
//    private Reader mReader;
//    Activity mactivity;
//    public final String ACTION_USB_PERMISSION = "com.tunetalk.tunedealer.USB_PERMISSION";
//    private UsbDevice mUsbDevice;
//    private final int PRODUCT_ID = 37068;
//    private final int VENDOR_ID = 1839;
//    private Activity context;
//    private final int SLOT_NUM = 0;
//    public static boolean dialogopen = false;
//    private ScanResultItemEntity scanResultItemEntity;
//    private AsyncCallbackListener<ScanResultItemEntity> actionCallback;
//    private AsyncCallbackListener<ScanResultItemEntity> idleCallback;
//
//
//    private byte[] mBuffer;
//    private byte[] mTempBuffer = new byte[1024];
//
//
//    APDU APDU = new APDU();
//    JPNEntity JPNEntity = new JPNEntity();
//
//
//    public void setActionCallback(AsyncCallbackListener<ScanResultItemEntity> resultCallback) {
//        this.actionCallback = resultCallback;
//    }
//
//    public void setIdleCallback(AsyncCallbackListener<ScanResultItemEntity> idleCallback) {
//        this.idleCallback = idleCallback;
//    }
//
//    public CardReader(Activity context) {
//        this.context = context;
//    }
//
//    private boolean findReader(){
//        mUsbManager = (UsbManager) context.getSystemService(Context.USB_SERVICE);
//        mPermissionIntent = PendingIntent.getBroadcast(context, 999, new Intent(ACTION_USB_PERMISSION), 0);
//        mReader = new Reader(mUsbManager);
//
//        for(UsbDevice usb : mUsbManager.getDeviceList().values())
//        {
//            if(usb.getProductId() == PRODUCT_ID && usb.getVendorId() == VENDOR_ID)
//            {
//                mUsbDevice = usb;
//                DocumentIntentManager.init().getIntentEntity().setUsbDevice(usb);
//                mUsbManager.requestPermission(mUsbDevice, mPermissionIntent);
//                if (dialogopen){
//                    PermissionActivity.dialog.dismiss();
//                }
//                return true;
//            }
//        }
//        return false;
//    }
//
//
//    public final BroadcastReceiver mReceiver = new BroadcastReceiver()
//    {
//        public void onReceive(Context context, Intent intent)
//        {
//            String action = intent.getAction();
//            String usbStateChangeAction = "android.hardware.usb.action.USB_STATE";
//
//            if(action.equalsIgnoreCase(usbStateChangeAction)) { //Check if change in USB state
//                if(intent.getExtras().getBoolean("connected")) {
//                    PermissionActivity.usbAttached = findReader();
//                    return;
//                } else {
//                    // USB was disconnected
//                }
//            }
//
//            if(action.equals(UsbManager.ACTION_USB_DEVICE_ATTACHED))
//            {
//                PermissionActivity.usbAttached = findReader();
//
//            }
//            else if(action.equals(ACTION_USB_PERMISSION))
//            {
//                synchronized (this)
//                {
//                    UsbDevice device = intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
//                    if (intent.getBooleanExtra(UsbManager.EXTRA_PERMISSION_GRANTED, false) )
//                    {
//                        if (device != null) {
//                            try {
//                                if(mUsbDevice==null){
//                                    mReader.open(DocumentIntentManager.init().getIntentEntity().getUsbDevice());
//                                }else{
//                                    mReader.open(mUsbDevice);
//
//                                }
//                                mReader.setOnStateChangeListener(new Reader.OnStateChangeListener() {
//                                    @Override
//                                    public void onStateChange(int slotNum, int prevState, int currState) {
//                                        if (currState == 2) {
//                                            initReader();
//                                        } else if (currState == 1) {
//                                            Log.e("Debug", "Smart card removed");
//                                        }
//                                    }
//                                });
//                            }catch (Exception e){
//                                Log.e("error1", e.getLocalizedMessage());
//                                e.printStackTrace();
//                            }
//                        }
//                    }
//                    else
//                    {
//                        Toast.makeText(context, "USB Permission Denied", Toast.LENGTH_SHORT).show();
//                    }
//                }
//            }
//            else if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action))
//            {
//                Toast.makeText(context, "USB Detached", Toast.LENGTH_SHORT).show();
//                PermissionActivity.usbAttached = false;
//            }
//
//        }
//    };
//
//
//
//    byte[] transmit(int bufferLength, byte[] setLength, byte[] setOffset, byte[] read)
//    {
//        try
//        {
//            byte[] tempBuff = new byte[1024];
//            byte[] targetBuffer = new byte[bufferLength];
//            mReader.transmit(SLOT_NUM, setLength, setLength.length, tempBuff, tempBuff.length);
//            mReader.transmit(SLOT_NUM, setOffset, setOffset.length, mTempBuffer, mTempBuffer.length);
//            mReader.transmit(SLOT_NUM, read, read.length, targetBuffer, bufferLength);
//            return targetBuffer;
//        }
//        catch (Exception ex)
//        {
//            try
//            {
//                byte[] tempBuff = new byte[1024];
//                byte[] targetBuffer = new byte[bufferLength];
//                mReader.transmit(SLOT_NUM, setLength, setLength.length, tempBuff, tempBuff.length);
//                mReader.transmit(SLOT_NUM, setOffset, setOffset.length, mTempBuffer, mTempBuffer.length);
//                mReader.transmit(SLOT_NUM, read, read.length, targetBuffer, bufferLength);
//                return targetBuffer;
//            }
//            catch (Exception exp)
//            {
//                exp.printStackTrace();
//                return null;
//            }
//        }
//    }
//
//
//
//    public void getDataFromReader() {
//        new AsyncTask<Void, Void, Void>()
//        {
//            ProgressDialog pd;
//            @Override
//            protected void onPreExecute()
//            {
//                try {
//                    super.onPreExecute();
//                    pd = ProgressDialog.show(context, "Please wait", "Reading MyKad...", false);
//
//                } catch (Exception exp) {
//                    if (pd != null) {
//                        if (pd.isShowing()) {
//                            pd.dismiss();
//                        }
//                    }
//
////                    if (!isFinishing()) {
////                        pd = ProgressDialog.show(context, "Error", "Please try again", false);
////                    }
//                    exp.printStackTrace();
//                }
//            }
//
//            @Override
//            protected void onPostExecute(Void aVoid)
//            {
//                pd.dismiss();
//                mapData();
//
//            }
//
//            @Override
//            protected Void doInBackground(Void... voids)
//            {
//                try
//                {
//                    readData();
//                }
//                catch (Exception ex)
//                {
//
//                }
//                return null;
//            }
//        }.execute();
//
//    }
//
//
//
//    void initReader()
//    {
//        new AsyncTask<Void, Void, Void>()
//        {
//            @Override
//            protected void onPreExecute()
//            {
//                super.onPreExecute();
//            }
//
//            @Override
//            protected void onPostExecute(Void aVoid)
//            {
//                super.onPostExecute(aVoid);
//                getDataFromReader();
//            }
//
//            @Override
//            protected Void doInBackground(Void... voids)
//            {
//                if(mReader.isOpened())
//                {
//                    try
//                    {
//                        mReader.power(SLOT_NUM, Reader.CARD_WARM_RESET);
//                        mReader.setProtocol(SLOT_NUM, Reader.PROTOCOL_T0);
//                    }
//                    catch (Exception ex)
//                    {
//                        try
//                        {
//                            mReader.power(SLOT_NUM, Reader.CARD_WARM_RESET);
//                            mReader.setProtocol(SLOT_NUM, Reader.PROTOCOL_T0);
//                        }
//                        catch (Exception exp)
//                        {
//                            exp.printStackTrace();
//                        }
//                    }
//                }
//                else
//                {
//                    Log.e("Debug", "Reader is closed");
//                }
//                return null;
//            }
//        }.execute();
//    }
//
//    public void readData(){
//        try{
//            mReader.transmit(SLOT_NUM, APDU.SELECT_JPN, APDU.SELECT_JPN.length, mTempBuffer, mTempBuffer.length);
//            mReader.transmit(SLOT_NUM, APDU.GET_RESPONSE, APDU.GET_RESPONSE.length, mTempBuffer, mTempBuffer.length);
//
//            APDU.OriginalName cmdOriginalName = APDU.new OriginalName();
//            JPNEntity.setOriginalName(transmit(cmdOriginalName.BUFFER_LENGTH, cmdOriginalName.LENGTH, cmdOriginalName.OFFSET, cmdOriginalName.READ), cmdOriginalName.STRING_LENGTH);
//
//            APDU.IDNumber cmdIDNumber = APDU.new IDNumber();
//            JPNEntity.setIDNumber(transmit(cmdIDNumber.BUFFER_LENGTH, cmdIDNumber.LENGTH, cmdIDNumber.OFFSET, cmdIDNumber.READ), cmdIDNumber.STRING_LENGTH);
//
//            APDU.BirthDate cmdBirthDate = APDU.new BirthDate();
//            JPNEntity.setBirthDate(transmit(cmdBirthDate.BUFFER_LENGTH, cmdBirthDate.LENGTH, cmdBirthDate.OFFSET, cmdBirthDate.READ), cmdBirthDate.STRING_LENGTH);
//
//            APDU.Gender cmdGender = APDU.new Gender();
//            JPNEntity.setGender(transmit(cmdGender.BUFFER_LENGTH, cmdGender.LENGTH, cmdGender.OFFSET, cmdGender.READ), cmdGender.STRING_LENGTH);
//
//            APDU.Address1 cmdAddress1 = APDU.new Address1();
//            JPNEntity.setAddress1(transmit(cmdAddress1.BUFFER_LENGTH, cmdAddress1.LENGTH, cmdAddress1.OFFSET, cmdAddress1.READ), cmdAddress1.STRING_LENGTH);
//
//            APDU.Address2 cmdAddress2 = APDU.new Address2();
//            JPNEntity.setAddress2(transmit(cmdAddress2.BUFFER_LENGTH, cmdAddress2.LENGTH, cmdAddress2.OFFSET, cmdAddress2.READ), cmdAddress2.STRING_LENGTH);
//
//            APDU.Address3 cmdAddress3 = APDU.new Address3();
//            JPNEntity.setAddress3(transmit(cmdAddress3.BUFFER_LENGTH, cmdAddress3.LENGTH, cmdAddress3.OFFSET, cmdAddress3.READ), cmdAddress3.STRING_LENGTH);
//
//            APDU.Postcode cmdPostcode = APDU.new Postcode();
//            JPNEntity.setPostcode(transmit(cmdPostcode.BUFFER_LENGTH, cmdPostcode.LENGTH, cmdPostcode.OFFSET, cmdPostcode.READ), cmdPostcode.STRING_LENGTH);
//
//            APDU.City cmdCity = APDU.new City();
//            JPNEntity.setCity(transmit(cmdCity.BUFFER_LENGTH, cmdCity.LENGTH, cmdCity.OFFSET, cmdCity.READ), cmdCity.STRING_LENGTH);
//
//            APDU.State cmdState = APDU.new State();
//            JPNEntity.setState(transmit(cmdState.BUFFER_LENGTH, cmdState.LENGTH, cmdState.OFFSET, cmdState.READ), cmdState.STRING_LENGTH);
//
//            Log.d("CARD READER", "readData: " + JPNEntity);
//        } catch (Exception e){
//            e.printStackTrace();
//        }
//    }
//
//    private void mapData(){
//        scanResultItemEntity = new ScanResultItemEntity();
//        scanResultItemEntity.setDocumentType(DocumentType.MYKAD);
//        if (JPNEntity != null) {
//            if (JPNEntity.getIDNumber() != null && !JPNEntity.getIDNumber().equalsIgnoreCase("") && JPNEntity.getIDNumber().length() >= 12){
//                scanResultItemEntity.setNric(JPNEntity.getIDNumber().trim());
//                scanResultItemEntity.setGender(Common.getGenderFromNRIC(scanResultItemEntity.getNric()));
//                scanResultItemEntity.setDob(Common.getDOBFromNRIC(scanResultItemEntity.getNric()));
//            }else{
//                Log.d("CARD READER", "mapData IDNumber Error: " + JPNEntity.getIDNumber());
//            }
//
//            if (JPNEntity.getOriginalName() != null && !JPNEntity.getOriginalName().equalsIgnoreCase("")) {
//                scanResultItemEntity.setFullName(JPNEntity.getOriginalName().trim());
//            } else {
//                Log.d("CARD READER", "mapData OriginalName Error: " + JPNEntity.getOriginalName());
//            }
//
//            String address = "";
//            if (JPNEntity.getAddress1() != null && JPNEntity.getAddress2() != null && JPNEntity.getAddress3() != null){
//                address = String.format("%s, %s, %s", JPNEntity.getAddress1().trim(), JPNEntity.getAddress2().trim(), JPNEntity.getAddress3().trim());
//            }
//            scanResultItemEntity.setAddress(address);
//
//            scanResultItemEntity.setPoscode(JPNEntity.getPostcode());
//            String city = JPNEntity.getCity() != null ? JPNEntity.getCity().trim() : JPNEntity.getCity();
//            scanResultItemEntity.setCity(city);
//
//            if (actionCallback != null) {
//                actionCallback.onActionCallback(scanResultItemEntity);
//                actionCallback = null;
//            } else {
//                if (idleCallback != null) {
//                    idleCallback.onActionCallback(scanResultItemEntity);
//                    idleCallback = null;
//                }
//
//            }
//        }else{
//            Log.d("CARD READER", "mapData Error");
//        }
//    }
//
//    public ScanResultItemEntity getScanResultItemEntity() {
//        return scanResultItemEntity;
//    }
//}
