package com.tunetalk.ttdealersdk.util;

import android.app.Activity;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.BounceInterpolator;

import androidx.appcompat.app.AlertDialog;

import com.google.android.material.snackbar.Snackbar;
import com.tunetalk.ttdealersdk.R;
import com.tunetalk.ttdealersdk.ocr.DocumentType;
import com.tunetalk.ttdealersdk.singleton.DocumentIntentManager;

public class AutoActivityUtils {

    // check whether user selected document type matches microblink returned document type
    public static boolean invalidDocumentType(final Activity activity, final boolean isRescanAction, final DocumentType documentType) {
        final DocumentType selectedType = DocumentIntentManager.init().getIntentEntity().getDocumentType();
        if (selectedType != documentType){
            final String message = String.format(activity.getString(R.string.invalid_document), selectedType);
            new AlertDialog.Builder(activity)
                    .setTitle("Opps...")
                    .setMessage(message)
                    .setCancelable(false)
                    .setPositiveButton("OK", new DialogInterface.OnClickListener()
                    {
                        @Override public void onClick (DialogInterface dialog, int which)
                        {
                            if (!isRescanAction) {
                                ActivityUtils.result(activity, Constant.ResultCode.FAILED, null, message);
                                activity.finish();
                            }
                        }
                    }).show();
            return true;
        } else {
            return false;
        }
    }


    // microblink scan return empty photo
    public static void noPhotoFoundDialog(final Activity activity) {
        new AlertDialog.Builder(activity)
                .setTitle("Opps...")
                .setMessage(activity.getString(R.string.cannot_read_photo))
                .setCancelable(false)
                .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        activity.finish();
                    }
                }).show();
    }


    // ok doc api return valid: false
    public static void fakeDocumentDialog(final Activity activity, final boolean isRescanAction, DocumentType documentType, final String message) {
        String documentName = getFakeDocumentType(documentType);
        String dialogMessage = String.format(activity.getString(R.string.fake_document), documentName);

        new AlertDialog.Builder(activity)
                .setTitle("Opps...")
                .setMessage(dialogMessage)
                .setCancelable(false)
                .setPositiveButton("OK", new DialogInterface.OnClickListener()
                {
                    @Override public void onClick (DialogInterface dialog, int which)
                    {
                        if (!isRescanAction) {
                            ActivityUtils.result(activity, Constant.ResultCode.FAILED, null, message);
                            activity.finish();
                        }
                    }
                }).show();
    }


    public static String getFakeDocumentType(DocumentType fakeDocument) {
        String documentName = "";
        switch (fakeDocument) {
            case MYKAD:
                documentName = "MyKad";
                break;
            case PASSPORT:
                documentName = "Passport";
                break;
            case MYPR:
                documentName = "MyPR";
                break;
            case ARMY_ID:
                documentName = "MyTentera";
                break;
        }

        return documentName;
    }


    public static void okDocUnreacheable(final Activity activity, final boolean isRescanAction){
        new AlertDialog.Builder(activity)
                .setTitle("Opps...")
                .setMessage(activity.getString(R.string.ok_doc_unreacheable))
                .setCancelable(false)
                .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (!isRescanAction) {
                            activity.setResult(Constant.ResultCode.FAILED);
                            activity.finish();
                        }
                    }
                }).show();
    }



    //Shared animations
    public static void animateErrorBounceWithCustomMessage (Activity activity, View v, String msg)
    {
        v.setTranslationX(75);
        v.animate()
                .translationX(0)
                .setInterpolator(new BounceInterpolator())
                .setDuration(500)
                .setStartDelay(200)
                .start();

        Snackbar snack = Snackbar.make(v, msg, Snackbar.LENGTH_LONG);
        ViewGroup group = (ViewGroup) snack.getView();
        group.setBackgroundColor(activity.getResources().getColor(R.color.SnackErrorBackground));
        snack.show();
    }


    public static void animateErrorBounce (Activity activity, View v)
    {
        v.setTranslationX(75);
        v.animate()
                .translationX(0)
                .setInterpolator(new BounceInterpolator())
                .setDuration(500)
                .setStartDelay(200)
                .start();

        Snackbar snack = Snackbar.make(v, R.string.snackbar_empty_field, Snackbar.LENGTH_LONG);
        ViewGroup group = (ViewGroup) snack.getView();
        group.setBackgroundColor(activity.getResources().getColor(R.color.SnackErrorBackground));
        snack.show();
    }


    public static void animateErrorBounceWithoutFocus (Activity activity, View v)
    {
        v.setTranslationX(75);
        v.animate()
                .translationX(0)
                .setInterpolator(new BounceInterpolator())
                .setDuration(500)
                .setStartDelay(300)
                .start();

        Snackbar snack = Snackbar.make(v, R.string.snackbar_empty_field, Snackbar.LENGTH_LONG);
        ViewGroup group = (ViewGroup) snack.getView();
        group.setBackgroundColor(activity.getResources().getColor(R.color.SnackErrorBackground));
        snack.show();
    }

}
