package com.tunetalk.ttdealersdk.util;

import android.app.Activity;
import android.content.Intent;

import java.io.Serializable;

public class ActivityUtils
{
    public static void result (Activity activity, int resultCode, Serializable object ,String errorMessage)
    {
        Intent i = activity.getIntent();

        if(object != null){
            i.putExtra(Constant.Key.Intent.OBJECT_RETURN,object);
        }

        if (Common.isValidString(errorMessage))
            i.putExtra("errorDescription", Common.getStringResourceByName(activity, errorMessage));

        activity.setResult(resultCode, i);
        activity.finish();
    }

    public static void result (Activity activity, int resultCode, String msisdn, String errorMessage)
    {
        Intent i = activity.getIntent();

        if (Common.isValidString(msisdn))
            i.putExtra("msisdn", msisdn);

        if (Common.isValidString(errorMessage))
            i.putExtra("errorDescription", Common.getStringResourceByName(activity, errorMessage));

        activity.setResult(resultCode, i);
        activity.finish();
    }

}
