package com.tunetalk.ttdealersdk.mykadreader.entity;

import java.math.BigInteger;

public class APDU
{
    public final byte[] SELECT_JPN = { (byte) 0x0, (byte) 0xA4, (byte) 0x4, (byte) 0x0, (byte) 0xA, (byte) 0xA0, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x74, (byte) 0x4A, (byte) 0x50, (byte) 0x4E, (byte) 0x0, (byte) 0x10 };

    public final byte[] SELECT_JPJ = { (byte) 0x0, (byte) 0xA4, (byte) 0x4, (byte) 0x0, (byte) 0xA, (byte) 0xA0, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x74, (byte) 0x4A, (byte) 0x50, (byte) 0x4A, (byte) 0x0, (byte) 0x10 };

    public final byte[] SELECT_IMM = { (byte) 0x0, (byte) 0xA4, (byte) 0x4, (byte) 0x0, (byte) 0xA, (byte) 0xA0, (byte) 0x0, (byte) 0x0,
            (byte) 0x0, (byte) 0x74, (byte) 0x49, (byte) 0x4D, (byte) 0x4D, (byte) 0x0, (byte) 0x10 };

    public final byte[] GET_RESPONSE = { (byte) 0x00, (byte) 0xC0, (byte) 0x00, (byte) 0x00, (byte) 0x05 };

    public class OriginalName
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x96, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x96, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x96 };
        public final int BUFFER_LENGTH = 152;
        public final int STRING_LENGTH = 150;
    }

    public class GMPCName
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x50, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x99, (byte) 0x00, (byte) 0x50, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x50 };
        public final int BUFFER_LENGTH = 82;
        public final int STRING_LENGTH = 80;
    }

    public class KPTName
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, 0x28, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0xE9, (byte) 0x0, (byte) 0x28, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x28 };
        public final int BUFFER_LENGTH = 42;
        public final int STRING_LENGTH = 40;
    }

    public class IDNumber
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, 0x0D, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x11, (byte) 0x01, (byte) 0x0D, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x0D };
        public final int BUFFER_LENGTH = 15;
        public final int STRING_LENGTH = 13;
    }

    public class OldIDNumber
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x08, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x1F, (byte) 0x01, (byte) 0x08, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x08 };
        public final int BUFFER_LENGTH = 10;
        public final int STRING_LENGTH = 8;
    }

    public class Gender
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x01, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x1E, (byte) 0x01, (byte) 0x01, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x01 };
        public final int BUFFER_LENGTH = 3;
        public final int STRING_LENGTH = 1;
    }

    public class BirthPlace
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x19, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x2B, (byte) 0x01, (byte) 0x19, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x19 };
        public final int BUFFER_LENGTH = 27;
        public final int STRING_LENGTH = 25;
    }

    public class BirthDate
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x04, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x27, (byte) 0x01, (byte) 0x04, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x04 };
        public final int BUFFER_LENGTH = 6;
        public final int STRING_LENGTH = 8;
    }

    public class DateIssue
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x04, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x44, (byte) 0x01, (byte) 0x04, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x04 };
        public final int BUFFER_LENGTH = 6;
        public final int STRING_LENGTH = 8;
    }

    public class Citizenship
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x12, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x48, (byte) 0x01, (byte) 0x12, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x12 };
        public final int BUFFER_LENGTH = 20;
        public final int STRING_LENGTH = 18;
    }

    public class Race
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x19, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x48, (byte) 0x01, (byte) 0x19, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x19 };
        public final int BUFFER_LENGTH = 27;
        public final int STRING_LENGTH = 25;
    }

    public class Religion
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x0B, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x73, (byte) 0x01, (byte) 0x0B, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x0B };
        public final int BUFFER_LENGTH = 13;
        public final int STRING_LENGTH = 11;
    }

    public class EastMalaysian
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x01, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x7E, (byte) 0x01, (byte) 0x01, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x01 };
        public final int BUFFER_LENGTH = 3;
        public final int STRING_LENGTH = 1;
    }

    public class RJ
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x02, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x7F, (byte) 0x01, (byte) 0x02, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x02 };
        public final int BUFFER_LENGTH = 5;
        public final int STRING_LENGTH = 2;
    }

    public class KT
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x02, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x81, (byte) 0x01, (byte) 0x02, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x02 };
        public final int BUFFER_LENGTH = 5;
        public final int STRING_LENGTH = 2;
    }

    public class OtherID
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x0B, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x83, (byte) 0x01, (byte) 0x0B, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x0B };
        public final int BUFFER_LENGTH = 13;
        public final int STRING_LENGTH = 11;
    }

    public class Category
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x01, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x8E, (byte) 0x01, (byte) 0x01, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x01 };
        public final int BUFFER_LENGTH = 3;
        public final int STRING_LENGTH = 1;
    }

    public class CardVersion
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x01, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x8F, (byte) 0x01, (byte) 0x01, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x01 };
        public final int BUFFER_LENGTH = 3;
        public final int STRING_LENGTH = 1;
    }

    public class GreenCardExpiry
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x04, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x90, (byte) 0x01, (byte) 0x04, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x04 };
        public final int BUFFER_LENGTH = 6;
        public final int STRING_LENGTH = 4;
    }

    public class GreenCardNationality
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x14, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x1, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x94, (byte) 0x01, (byte) 0x14, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x14 };
        public final int BUFFER_LENGTH = 22;
        public final int STRING_LENGTH = 20;
    }

    public class Photo
    {
        public int CURRENT_OFFSET = -252;
        public final int BUFFER_SEGMENT_LENGTH = 257;
        public final int BUFFER_SEGMENT_EXTEND_LENGTH = 265;
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0xFF, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0xFF };

        public final int SUBSTRING_LENGTH = 20;
        public final String TRUNCATE = "90000000000000000000";
        public final String HEADER_EMPTY = "00000000000000000000";
        public final String HEADER_80K_CHIP = "96010000000000000000";
        public final String HEADER_64K_CHIP = "96070000000000000000";
        //NOTE: 32K HEADER Unknown

        public byte[] getCurrentOffset()
        {
            byte[] offset = BigInteger.valueOf(CURRENT_OFFSET).toByteArray();
            if(CURRENT_OFFSET > 255)
                return new byte[] { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x02, (byte) 0x0, (byte) 0x1, 0x00, offset[1], offset[0], (byte) 0xFF, (byte) 0x0 };
            else
                return new byte[] { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x02, (byte) 0x0, (byte) 0x1, 0x00, offset[0], (byte) 0x00, (byte) 0xFF, (byte) 0x0 };
        }
    }

    public class RightThumb
    {
        public int CURRENT_OFFSET = -238;
        public final int BUFFER_SEGMENT_LENGTH = 257;
        public final int BUFFER_SEGMENT_EXTEND_LENGTH = 265;
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0xFF, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0xFF };

        public final int SUBSTRING_LENGTH = 20;
        public final String TRUNCATE = "90000000000000000000";
        public final String HEADER_EMPTY = "00000000000000000000";
        public final String HEADER_80K_CHIP = "96010000000000000000";
        public final String HEADER_64K_CHIP = "96070000000000000000";
        //NOTE: 32K HEADER Unknown

        public byte[] getCurrentOffset()
        {
            byte[] offset = BigInteger.valueOf(CURRENT_OFFSET).toByteArray();
            if(CURRENT_OFFSET > 255)
                return new byte[] { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x03, (byte) 0x0, (byte) 0x1, 0x00, offset[1], offset[0], (byte) 0xFF, (byte) 0x0 };
            else
                return new byte[] { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x03, (byte) 0x0, (byte) 0x1, 0x00, offset[0], (byte) 0x00, (byte) 0xFF, (byte) 0x0 };
        }
    }

    public class LeftThumb
    {
        public int CURRENT_OFFSET = 621;
        public final int BUFFER_SEGMENT_LENGTH = 257;
        public final int BUFFER_SEGMENT_EXTEND_LENGTH = 265;
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0xFF, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0xFF };

        public final int SUBSTRING_LENGTH = 20;
        public final String TRUNCATE = "90000000000000000000";
        public final String HEADER_EMPTY = "00000000000000000000";
        public final String HEADER_80K_CHIP = "96010000000000000000";
        public final String HEADER_64K_CHIP = "96070000000000000000";
        //NOTE: 32K HEADER Unknown

        public byte[] getCurrentOffset()
        {
            byte[] offset = BigInteger.valueOf(CURRENT_OFFSET).toByteArray();
            return new byte[] { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x03, (byte) 0x0, (byte) 0x1, 0x00, offset[1], offset[0], (byte) 0xFF, (byte) 0x0 };
        }
    }

    public class Address1
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x1E, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x1E, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x1E };
        public final int BUFFER_LENGTH = 32;
        public final int STRING_LENGTH = 30;
    }

    public class Address2
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x1E, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x21, (byte) 0x00, (byte) 0x1E, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x1E };
        public final int BUFFER_LENGTH = 32;
        public final int STRING_LENGTH = 30;
    }

    public class Address3
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x1E, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x3F, (byte) 0x00, (byte) 0x1E, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x1E };
        public final int BUFFER_LENGTH = 32;
        public final int STRING_LENGTH = 30;
    }

    public class Postcode
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x03, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x5D, (byte) 0x00, (byte) 0x03, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x03 };
        public final int BUFFER_LENGTH = 5;
        public final int STRING_LENGTH = 5;
    }

    public class City
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x19, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x60, (byte) 0x00, (byte) 0x19, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x19 };
        public final int BUFFER_LENGTH = 27;
        public final int STRING_LENGTH = 25;
    }

    public class State
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x1E, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x04, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x79, (byte) 0x00, (byte) 0x1E, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x1E };
        public final int BUFFER_LENGTH = 32;
        public final int STRING_LENGTH = 30;
    }

    public class SocsoNumber
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x09, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x05, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x09, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x09 };
        public final int BUFFER_LENGTH = 11;
        public final int STRING_LENGTH = 9;
    }

    public class Locality
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x0A, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x06, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x0A, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x0A };
        public final int BUFFER_LENGTH = 12;
        public final int STRING_LENGTH = 10;
    }

    public class OwnerCategory
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x01, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x06, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x03, (byte) 0x00, (byte) 0x01, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x01 };
        public final int BUFFER_LENGTH = 3;
        public final int STRING_LENGTH = 1;
    }

    public class LicenseType
    {
        public final byte[] LENGTH = { (byte) 0xC8, (byte) 0x32, (byte) 0x0, (byte) 0x0, (byte) 0x5, (byte) 0x8, (byte) 0x0, (byte) 0x0, (byte) 0x0C, (byte) 0x0 };
        public final byte[] OFFSET = { (byte) 0xCC, (byte) 0x0, (byte) 0x0, (byte) 0x0, (byte) 0x8, (byte) 0x06, (byte) 0x0, (byte) 0x1, 0x00, (byte) 0x04, (byte) 0x00, (byte) 0x0C, (byte) 0x0 };
        public final byte[] READ = { (byte) 0xCC, (byte) 0x6, (byte) 0x0, (byte) 0x0, (byte) 0x0C };
        public final int BUFFER_LENGTH = 14;
        public final int STRING_LENGTH = 12;
    }

    public class VehicleClass
    {

    }

    public class PSVUsage
    {

    }

    public class PSVDescription
    {

    }

    public class GDLUsage
    {

    }

    public class GDLDescription
    {

    }

    public class ValidityPeriod
    {

    }

    public class HandicappedRegistration
    {

    }

    public class KejaraPoints
    {

    }

    public class SuspensionNumber
    {

    }

    public class LastKejaraUpdate
    {

    }
}