package com.tunetalk.ttdealersdk.entity.response.intent;

import android.hardware.usb.UsbDevice;

import com.tunetalk.ttdealersdk.enums.ServiceCategories;
import com.tunetalk.ttdealersdk.ocr.DocumentType;
import com.tunetalk.ttdealersdk.ocr.entity.ScanResultItemEntity;

/**
 * Singleton entity to store intent variable
 *
 */
public class DocumentIntentEntity
{
    String apiKey;
    String partnerDealerId;
    String herogoValidateIccidReqBody;
    ServiceCategories serviceCategories;
    DocumentType documentType;
    UsbDevice usbDevice;
    ScanResultItemEntity scanResultItemEntity;

    public String getHerogoValidateIccidReqBody() { return herogoValidateIccidReqBody; }

    public void setHerogoValidateIccidReqBody(String herogoValidateIccidReqBody) {
        this.herogoValidateIccidReqBody = herogoValidateIccidReqBody;
    }

    public String getApiKey ()
    {
        return apiKey;
    }

    public DocumentIntentEntity setApiKey (String apiKey)
    {
        this.apiKey = apiKey;
        return this;
    }

    public String getPartnerDealerCode ()
    {
        return partnerDealerId;
    }

    public DocumentIntentEntity setPartnerDealerCode (String partnerDealerId)
    {
        this.partnerDealerId = partnerDealerId;
        return this;
    }

    public ServiceCategories getServiceCategories ()
    {
        return serviceCategories;
    }

    public DocumentIntentEntity setServiceCategories (ServiceCategories serviceCategories)
    {
        this.serviceCategories = serviceCategories;
        return this;
    }

    public DocumentType getDocumentType ()
    {
        return documentType;
    }

    public DocumentIntentEntity setDocumentType (DocumentType documentType)
    {
        this.documentType = documentType;
        return this;
    }

    public UsbDevice getUsbDevice() {
        return usbDevice;
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public ScanResultItemEntity getScanResultItemEntity() { return scanResultItemEntity;
    }

    public void setScanResultItemEntity(ScanResultItemEntity scanResultItemEntity) { this.scanResultItemEntity = scanResultItemEntity; }
}
