package com.tunetalk.ttdealersdk.activity;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Vibrator;
import android.text.InputFilter;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.signature.StringSignature;
import com.google.android.material.snackbar.Snackbar;
import com.microblink.entities.recognizers.RecognizerBundle;
import com.microblink.uisettings.DocumentUISettings;
import com.muddzdev.styleabletoastlibrary.StyleableToast;
import com.rey.material.widget.Button;
import com.rey.material.widget.CheckBox;
import com.rey.material.widget.EditText;
import com.tunetalk.ttdealersdk.R;
import com.tunetalk.ttdealersdk.api.ApiProvider;
import com.tunetalk.ttdealersdk.api.ApiRequestBody;
import com.tunetalk.ttdealersdk.api.OnApiCallBack;
import com.tunetalk.ttdealersdk.base.BaseActivity;
import com.tunetalk.ttdealersdk.entity.request.SIMReplacementEntity;
import com.tunetalk.ttdealersdk.entity.response.OkDocEntity;
import com.tunetalk.ttdealersdk.entity.response.UploadEntity;
import com.tunetalk.ttdealersdk.entity.response.sql.TaskEntity;
import com.tunetalk.ttdealersdk.ocr.DocumentType;
import com.tunetalk.ttdealersdk.ocr.OCRHelper;
import com.tunetalk.ttdealersdk.ocr.OnScanResult;
import com.tunetalk.ttdealersdk.ocr.entity.ScanResultEntity;
import com.tunetalk.ttdealersdk.ocr.entity.ScanResultItemEntity;
import com.tunetalk.ttdealersdk.singleton.DatabaseManager;
import com.tunetalk.ttdealersdk.singleton.DocumentIntentManager;
import com.tunetalk.ttdealersdk.sql.OnSqlResultListener;
import com.tunetalk.ttdealersdk.util.ActivityUtils;
import com.tunetalk.ttdealersdk.util.AutoActivityUtils;
import com.tunetalk.ttdealersdk.util.Base64;
import com.tunetalk.ttdealersdk.util.Common;
import com.tunetalk.ttdealersdk.util.Constant;
import com.tunetalk.ttdealersdk.util.FileUtils;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import static com.tunetalk.ttdealersdk.util.AutoActivityUtils.animateErrorBounce;
import static com.tunetalk.ttdealersdk.util.AutoActivityUtils.animateErrorBounceWithCustomMessage;

public class SIMReplacementAutoActivity extends BaseActivity
{
    private final int OCR_REQUEST_CODE = 95;
    private final int OCR_BARCODE_REQUEST_CODE = 96;

    ScrollView svSimReg;
    CheckBox chkIsMalaysian;
    Button btnNext;
    EditText etLast8Digit, etFullName;
    EditText etNIRC, etPassport, etMobileNumber, etEMAIL;
    LinearLayout[] llRow;
    ImageView ivPhoto1;
    byte[] mBuffer1;
    byte[] bufferWithoutWatermark;

    boolean isMalaysian = true;
    boolean isMyTentera = false;
    boolean isActionFromMenu = false;
    StyleableToast mStyleableToast;
    Timer mTimer;
    String myTenteraNric;

    boolean isActivityExist = true;
    RecognizerBundle mRecognizerBundle;
    private ScanResultItemEntity mScanResultItemEntity;
    private ScanResultItemEntity entityBeforeValidation = new ScanResultItemEntity();

    @Override
    protected void onCreate (Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_sim_auto_replacement);
        setToolbarTitle(R.string.activity_sim_replace);

        findView(); //Included declare some listener here
        btnNextListener(); //EditText condition checking

        boolean useCardReaderInput = getIntent().getBooleanExtra("useCardReader", false);
        if (useCardReaderInput){
            ScanResultItemEntity myKad = DocumentIntentManager.init().getIntentEntity().getScanResultItemEntity();
            etFullName.setText(myKad.getFullName());
            etNIRC.setText(myKad.getNric());

            enableInputFromDocumentType();

            Intent intent = new Intent(mActivity, MySurfaceView.class);
            intent.putExtra("Type", 1);
            intent.putExtra("Position", 1);
            startCameraActivityWithDelay(intent, CAPTURE_REQUEST_CODE);

        } else {
            getCaptureMode(DocumentIntentManager.init().getIntentEntity().getDocumentType());
        }

        chkIsMalaysian.setEnabled(false);
    }

    private void getCaptureMode (DocumentType mode)
    {
        switch (mode)
        {
            case MYKAD:
                capture(0);
                break;
            case PASSPORT:
                chkIsMalaysian.setChecked(true);
                capture(1);
                break;
            case IKAD:
                chkIsMalaysian.setChecked(true);
                capture(2);
                break;
            case ARMY_ID:
                isMyTentera = true;
                capture(3);
                break;
            case MYPR:
                capture(4);
                break;
            case IMM13:
                chkIsMalaysian.setChecked(true);
                capture(5);
                break;
            case WORK_PERMIT:
                chkIsMalaysian.setChecked(true);
                capture(6);
                break;
            case VISA:
                chkIsMalaysian.setChecked(true);
                capture(7);
                break;
            case BARCODE:
                capture(8);
            default:
                break;
        }
    }

    private void findView ()
    {
        //CAUTION: FIXED ARRAY SIZE
        //TODO: Update LinearLayout value/size/whatever according to Layout
        llRow = new LinearLayout[8];
        llRow[0] = (LinearLayout) findViewById(R.id.replace_ll_row1);
        llRow[1] = (LinearLayout) findViewById(R.id.replace_ll_row2);
//        llRow[2] = (LinearLayout) findViewById(R.id.replace_ll_row3);
        llRow[3] = (LinearLayout) findViewById(R.id.replace_ll_row4);
        llRow[4] = (LinearLayout) findViewById(R.id.replace_ll_row5);
        llRow[5] = (LinearLayout) findViewById(R.id.replace_ll_row6);
        llRow[6] = (LinearLayout) findViewById(R.id.replace_ll_row8);

        svSimReg = (ScrollView) findViewById(R.id.replace_scrollview);
        btnNext = (Button) findViewById(R.id.replace_btnNext);
        chkIsMalaysian = (CheckBox) findViewById(R.id.replace_chkIsMalaysian);

        etLast8Digit = (EditText) findViewById(R.id.replace_etLast8Digit);
        etFullName = (EditText) findViewById(R.id.replace_etFullName);
        etEMAIL = (EditText) findViewById(R.id.replace_etEmail);
        etNIRC = (EditText) findViewById(R.id.replace_etNIRC);
        etPassport = (EditText) findViewById(R.id.replace_etPassport);
        etMobileNumber = (EditText) findViewById(R.id.replace_etPhoneNumber);
        ivPhoto1 = (ImageView) findViewById(R.id.ivPhoto1);


        etPassport.setFilters(new InputFilter[] {new InputFilter.AllCaps()});
        etPassport.setEnabled(false);

        etLast8Digit.setOnFocusChangeListener(new View.OnFocusChangeListener()
        {
            @Override
            public void onFocusChange (View view, boolean focused)
            {
                if (focused)
                {
                    etLast8Digit.setHint(getResources().getString(R.string.simreg_text_last_8digit));
                    etLast8Digit.setTextColor(getResources().getColor(R.color.TextPrimaryDark));
                }
                else if (! focused && etLast8Digit.length() != 8 && etLast8Digit.length() != 0)
                {
                    etLast8Digit.setHint(getResources().getString(R.string.error_simreg_last8digit));
                    etLast8Digit.setTextColor(getResources().getColor(R.color.TextError));
                    animateErrorBounceWithCustomMessage(mActivity, etNIRC, getResources().getString(R.string.snackbar_wrong_sim_num));
                }
                else
                {
                    etLast8Digit.setHint(getResources().getString(R.string.simreg_text_last_8digit));
                    etLast8Digit.setTextColor(getResources().getColor(R.color.TextPrimaryDark));
                }
            }
        });

        etNIRC.setOnFocusChangeListener(new View.OnFocusChangeListener()
        {
            @Override
            public void onFocusChange (View view, boolean focused)
            {
                if (focused)
                {
                    etNIRC.setHint(getResources().getString(R.string.common_text_NIRC));
                    etNIRC.setTextColor(getResources().getColor(R.color.TextPrimaryDark));
                }
                else if (! focused && etNIRC.length() != 12 && etNIRC.length() != 0)
                {
                    etNIRC.setHint(getResources().getString(R.string.error_simreg_nirc));
                    etNIRC.setTextColor(getResources().getColor(R.color.TextError));
                    animateErrorBounceWithCustomMessage(mActivity, etNIRC, getResources().getString(R.string.snackbar_wrong_nirc));
                }
                else
                {
                    etNIRC.setHint(getResources().getString(R.string.common_text_NIRC));
                    etNIRC.setTextColor(getResources().getColor(R.color.TextPrimaryDark));
                }
            }
        });

        chkIsMalaysian.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            @Override
            public void onCheckedChanged (CompoundButton compoundButton, boolean isChecked)
            {
                isMalaysian = ! isChecked;
                animateNonMalaysian(! isMalaysian);
            }
        });
    }

    private void btnNextListener ()
    {
        final int offset = 20;
        btnNext.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick (View view)
            {
                try
                {
                    int year = mCurrentYear;
                    if (isMalaysian)
                    {
                        Date nirc = null;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());

                        if (etNIRC.getText().toString().length() > 0) {
                            String idToProcess = isMyTentera ? myTenteraNric : etNIRC.getText().toString();

                            String date = sdf.format(Common.getAdjustedDate(idToProcess.substring(0, 2)));

                            nirc = sdf.parse(date.substring(0, 4) + "-" + idToProcess.substring(2, 4)
                                    + "-" + idToProcess.substring(4, 6));

                        }

                        sdf = new SimpleDateFormat("yyyy", Locale.getDefault());
                        year = Integer.parseInt(sdf.format(nirc));
                    }

                    if (etLast8Digit.length() != 8)
                    {
                        svSimReg.smoothScrollTo(0, llRow[0].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etLast8Digit, getString(R.string.snackbar_something_not_correct));
                    }
                    else if (etFullName.length() == 0)
                    {
                        svSimReg.smoothScrollTo(0, llRow[1].getTop() - offset);
                        animateErrorBounce(mActivity, etFullName);
                    }
                    else if (! Common.IsName(chkIsMalaysian.isChecked(), etFullName.getText().toString().trim()))
                    {
                        svSimReg.smoothScrollTo(0, llRow[1].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etFullName, "Please make sure full name is correct.");
                    }
                    else if (! isMalaysian && etPassport.length() == 0)
                    {
                        svSimReg.smoothScrollTo(0, llRow[4].getTop() - offset);
                        animateErrorBounce(mActivity, etPassport);
                    }
                    else if (isMalaysian && etNIRC.length() != 12 && !isMyTentera)
                    {
                        svSimReg.smoothScrollTo(0, llRow[4].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etNIRC, getString(R.string.snackbar_something_not_correct));
                    }
                    else if (isMalaysian && ! Common.IsNIRC(etNIRC.getText().toString(), mCurrentYear)&& !isMyTentera)
                    {
                        svSimReg.smoothScrollTo(0, llRow[4].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etNIRC, getString(R.string.snackbar_something_not_correct));
                    }
                    else if (isMalaysian && (year > mCurrentYear - 12))
                    {
                        svSimReg.smoothScrollTo(0, llRow[4].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etNIRC, "Age cannot younger than 12 years old.");
                    }
                    else if (etEMAIL.getText().toString().trim().length() > 0 && ! android.util.Patterns.EMAIL_ADDRESS.matcher(etEMAIL.getText()).matches())
                    {
                        svSimReg.smoothScrollTo(0, llRow[5].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etEMAIL, getString(R.string.snackbar_something_not_correct));
                    }
                    else if (! Common.IsMobileNumber(etMobileNumber.getText().toString()))
                    {
                        svSimReg.smoothScrollTo(0, llRow[6].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etMobileNumber, getString(R.string.error_incorrect_mobile_number));
                    }
                    else if (mBuffer1 == null || mBuffer1.length == 0)
                    {
                        svSimReg.smoothScrollTo(0, ivPhoto1.getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, ivPhoto1, "Form cannot submit without identity photo, please retake.");

                    }
                    else if (etEMAIL.getText().length() > 0 && etEMAIL.getText().toString().contains("tunetalk.com") && ! etEMAIL.getText().toString().equalsIgnoreCase("apps@tunetalk.com"))
                    {
                        svSimReg.smoothScrollTo(0, llRow[13].getTop() - offset);
                        animateErrorBounceWithCustomMessage(mActivity, etEMAIL, "Email ending with @tunetalk.com. Please use another email address.");
                    }
                    else
                    {
                        if (Common.hasConnectivity(getApplicationContext()))
                            replaceSim();
                        else
                            addTaskToQueue();
                    }
                }
                catch (Exception ex)
                {
                    ex.printStackTrace();
                }
            }
        });
    }

    @SuppressLint ("StaticFieldLeak")
    void replaceSim ()
    {
        final SIMReplacementEntity entity = new SIMReplacementEntity()
            .setLast8Digit(etLast8Digit.getText().toString().trim())
            .setFullName(etFullName.getText().toString().trim())
            .setIsMalaysian(isMalaysian)
            .setMyTentera(isMyTentera)
            .setMobileNumber(etMobileNumber.getText().toString().trim())
            .setEMAIL(etEMAIL.getText().toString().trim())
            .setStaffLoginId(DocumentIntentManager.init().getIntentEntity().getPartnerDealerCode())
            .setManual(false);

        if (isMalaysian)
            entity.setNIRC(etNIRC.getText().toString().trim());
        else
            entity.setPassport(etPassport.getText().toString().trim());

        entity.setImageOne(Base64.encodeBytes(mBuffer1));

        JSONObject jsonObject = ApiRequestBody.getSimReplacementRequestBody(this, entity);
        ApiProvider.simReplacement(this, jsonObject, new OnApiCallBack<UploadEntity>()
        {
            @Override public void onSuccess (UploadEntity response)
            {
                if (response.getResultCode())
                {
                    ActivityUtils.result(mActivity, Constant.ResultCode.SUCCESSFUL,entity, null);
                }
                else
                {
                    if (Common.isValidString(response.getMessage()) && response.getCode().equals("-500"))
                    {
                        ActivityUtils.result(mActivity, Constant.ResultCode.FAILED, null,response.getMessage());
                    }
                }
            }

            @Override public void onFailure ()
            {

            }
        });

    }

    @SuppressLint ("StaticFieldLeak")
    void addTaskToQueue ()
    {
        final SIMReplacementEntity simReplacemEntentity = new SIMReplacementEntity()
            .setLast8Digit(etLast8Digit.getText().toString().trim())
            .setFullName(etFullName.getText().toString().trim())
            .setIsMalaysian(isMalaysian)
            .setMyTentera(isMyTentera)
            .setMobileNumber(etMobileNumber.getText().toString().trim())
            .setEMAIL(etEMAIL.getText().toString().trim())
            .setStaffLoginId(DocumentIntentManager.init().getIntentEntity().getPartnerDealerCode())
            .setManual(false);

        if (isMalaysian)
            simReplacemEntentity.setNIRC(etNIRC.getText().toString().trim());
        else
            simReplacemEntentity.setPassport(etPassport.getText().toString().trim());

        simReplacemEntentity.setImageOne(Base64.encodeBytes(mBuffer1));

        DatabaseManager.get().persistSimReplacementRecord(this, simReplacemEntentity, new OnSqlResultListener()
        {
            @Override public void onSuccess (TaskEntity entity)
            {
                ActivityUtils.result(mActivity, Constant.ResultCode.OFFLINE_SERVICE,simReplacemEntentity, null);
            }

            @Override public void onFailure ()
            {
                Toast.makeText(mActivity, getResources().getString(R.string.toast_unknown_error), Toast.LENGTH_LONG).show();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu (Menu menu)
    {
        getMenuInflater().inflate(R.menu.menu_rescan, menu);

        MenuItem item = menu.findItem(R.id.menu_rescan);
        item.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener()
        {
            @Override
            public boolean onMenuItemClick (MenuItem item)
            {
                String[] options = new String[2];
                options[0] = getResources().getStringArray(R.array.orc_rescan)[getIntent().getIntExtra("Mode", 0)];
                options[1] = getResources().getStringArray(R.array.orc_rescan)[getResources().getStringArray(R.array.orc_rescan).length - 1];

                new AlertDialog.Builder(mActivity, R.style.DialogStyle)
                    .setTitle(R.string.ocr_select_document)
                    .setSingleChoiceItems(options, 100, new DialogInterface.OnClickListener()
                    {
                        @Override
                        public void onClick (DialogInterface dialog, int which)
                        {
                            dialog.dismiss();
                            isActionFromMenu = true;
                            if (which == 0)
                            {
                                capture(getIntent().getIntExtra("Mode", 0));
                            }

                            if (which == 1)
                                capture(8);
                        }
                    })
                    .setNegativeButton("BACK", new DialogInterface.OnClickListener()
                    {
                        @Override
                        public void onClick (DialogInterface dialog, int which)
                        {
                            dialog.dismiss();
                        }
                    }).show();
                return false;
            }
        });

        return super.onCreateOptionsMenu(menu);
    }

    private void animateNonMalaysian (boolean isChecked)
    {
        final ValueAnimator vaNIRC, vaPassport;

        if (isChecked)
        {
            vaNIRC = ValueAnimator.ofFloat(10f, 0f);
            vaNIRC.addUpdateListener(new ValueAnimator.AnimatorUpdateListener()
            {
                @Override
                public void onAnimationUpdate (ValueAnimator valueAnimator)
                {
                    etNIRC.setLayoutParams(new LinearLayout.LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, (float) valueAnimator.getAnimatedValue()));
                }
            });

            vaPassport = ValueAnimator.ofFloat(0f, 10f);
            vaPassport.addUpdateListener(new ValueAnimator.AnimatorUpdateListener()
            {
                @Override
                public void onAnimationUpdate (ValueAnimator valueAnimator)
                {
                    etPassport.setLayoutParams(new LinearLayout.LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, (float) valueAnimator.getAnimatedValue()));
                }
            });
        }
        else
        {
            vaNIRC = ValueAnimator.ofFloat(0f, 10f);
            vaNIRC.addUpdateListener(new ValueAnimator.AnimatorUpdateListener()
            {
                @Override
                public void onAnimationUpdate (ValueAnimator valueAnimator)
                {
                    etNIRC.setLayoutParams(new LinearLayout.LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, (float) valueAnimator.getAnimatedValue()));
                }
            });

            vaPassport = ValueAnimator.ofFloat(10f, 0f);
            vaPassport.addUpdateListener(new ValueAnimator.AnimatorUpdateListener()
            {
                @Override
                public void onAnimationUpdate (ValueAnimator valueAnimator)
                {
                    etPassport.setLayoutParams(new LinearLayout.LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, (float) valueAnimator.getAnimatedValue()));
                }
            });
        }

        vaNIRC.setDuration(500);
        vaPassport.setDuration(500);
        vaNIRC.setInterpolator(new DecelerateInterpolator());
        vaPassport.setInterpolator(new DecelerateInterpolator());
        etPassport.setText(null);
        etNIRC.setText(null);
        vaNIRC.start();
        vaPassport.start();
    }

    void enableInputFromDocumentType(){
        etNIRC.setEnabled(etNIRC.getText() == null || etNIRC.getText().toString().length() <= 0);
        etFullName.setEnabled(etFullName.getText() == null || etFullName.getText().toString().length() <= 0);
        etPassport.setEnabled(etPassport.getText() == null || etPassport.getText().toString().length() <= 0);
    }

    @Override
    protected void onActivityResult (int requestCode, int resultCode, Intent data)
    {
        super.onActivityResult(requestCode, resultCode, data);

        isActivityExist = false;

        if (mTimer != null)
        {
            mTimer.purge();
            mTimer.cancel();
        }

        if (requestCode == 200 && resultCode == RESULT_OK)
            finish();

        if (requestCode == CAPTURE_REQUEST_CODE && resultCode == RESULT_CANCELED)
            finish();

        if (resultCode == RESULT_OK)
        {
            if (data != null)
            {
                if (requestCode == CAPTURE_REQUEST_CODE){
                    if (data.hasExtra("ImageBuffer")) {
                        bufferWithoutWatermark = data.getExtras().getByteArray("ImageBuffer");
                        proceedToScanSim();
                    }
                    return;
                }

                final Vibrator v = (Vibrator) mActivity.getSystemService(Context.VIBRATOR_SERVICE);
                v.vibrate(200);

                final String filePath = FileUtils.ORC_DIR + "/identity.jpg";

                try
                {
                    mRecognizerBundle.loadFromIntent(data);
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }

                if (requestCode == OCR_REQUEST_CODE)
                {
                    OCRHelper.get().getResult(mRecognizerBundle, new OnScanResult()
                    {
                        @Override public void onScanResult (ScanResultEntity entity)
                        {
                            try
                            {
                                if(entity.getMyKad() != null)
                                {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getMyKad().getDocumentType())) {
                                        return;
                                    }
                                    entityBeforeValidation = entity.getMyKad();
                                    okDocValidation();
                                }
                                if(entity.getMypr() != null)
                                {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getMypr().getDocumentType())) {
                                        return;
                                    }
                                    entityBeforeValidation = entity.getMypr();
                                    okDocValidation();
                                }
                                else if (entity.getMrtd() != null) {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getMrtd().getDocumentType())) {
                                        return;
                                    }
                                    entityBeforeValidation = entity.getMrtd();
                                    okDocValidation();
                                }
                                else if(entity.getMyTentera() != null)
                                {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getMyTentera().getDocumentType())) {
                                        return;
                                    }
                                    entityBeforeValidation = entity.getMyTentera();
                                    okDocValidation();
                                }
                                else if (entity.getImm13() != null) // skip okDocValidation
                                {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getImm13().getDocumentType())) {
                                        return;
                                    }
                                    etFullName.setText(entity.getImm13().getFullName());
                                    etPassport.setText(entity.getImm13().getPassportNumber());
                                    proceedToScanSim();
                                }
                                else if (entity.getiKad() != null) // skip okDocValidation
                                {
                                    if (AutoActivityUtils.invalidDocumentType(mActivity, isActionFromMenu, entity.getiKad().getDocumentType())) {
                                        return;
                                    }
                                    etFullName.setText(entity.getiKad().getFullName());
                                    etPassport.setText(entity.getiKad().getPassportNumber());
                                    proceedToScanSim();
                                }
                            }
                            catch (Exception e)
                            {
                                e.printStackTrace();
                            }

                            enableInputFromDocumentType();
                        }

                        @Override public void onImageResult (byte[] imageBytes)
                        {
                            if (imageBytes == null || imageBytes.length == 0)
                            {
                                AutoActivityUtils.noPhotoFoundDialog(mActivity);
                            }
                            else
                            {
                                bufferWithoutWatermark = imageBytes;
                            }
                        }
                    });
                }
                else if (requestCode == OCR_BARCODE_REQUEST_CODE)
                {
                    isActionFromMenu = false;

                    OCRHelper.get().getResult(mRecognizerBundle, new OnScanResult()
                    {
                        @Override public void onScanResult (ScanResultEntity entity)
                        {
                            try
                            {
                                if(entity.getBarcode() != null)
                                {
                                    String mReferenceSimNumber = Common.extract8DigitSIM(entity.getBarcode().getScannedBarCode());
                                    etLast8Digit.setText(mReferenceSimNumber);
                                }
                            }
                            catch (Exception e)
                            {
                                e.printStackTrace();
                            }
                        }

                        @Override public void onImageResult (byte[] imageBytes)
                        {

                        }
                    });
                }
            }
        }
        else
        {
            if (requestCode != OCR_BARCODE_REQUEST_CODE)
            {
                if (! isActionFromMenu)
                {
                    if (requestCode == OCR_REQUEST_CODE)
                        finish();
                }
            }
        }
    }

    private void okDocValidation(){

        String imageBase64 = Base64.encodeBytes(bufferWithoutWatermark);

        JSONObject request =  ApiRequestBody.getOkDocRequestBody(entityBeforeValidation, bufferWithoutWatermark);

        if (Common.hasConnectivity(mActivity)) {
            ApiProvider.okDoc(mActivity, entityBeforeValidation.getDocumentType(), request, new OnApiCallBack<OkDocEntity>() {
                        @Override
                        public void onSuccess(final OkDocEntity response) {
                            if (response.isValidDocument()) {
                                populateValidDocument();

                            } else {
                                AutoActivityUtils.fakeDocumentDialog(mActivity, isActionFromMenu, entityBeforeValidation.getDocumentType(), response.getMessage());
                            }
                        }

                        @Override
                        public void onFailure() {
                            AutoActivityUtils.okDocUnreacheable(mActivity, isActionFromMenu);
                        }
                    }
            );
        } else {
            populateValidDocument();
        }
    }


    private void populateValidDocument() {
        mScanResultItemEntity = entityBeforeValidation;

        switch (mScanResultItemEntity.getDocumentType()) {
            case MYKAD:
            case MYPR:
                etFullName.setText(mScanResultItemEntity.getFullName());
                etNIRC.setText(mScanResultItemEntity.getNric());
                break;

            case PASSPORT:
                etFullName.setText(mScanResultItemEntity.getFullName());
                etPassport.setText(mScanResultItemEntity.getPassportNumber());
                break;

            case ARMY_ID:
                etNIRC.setHint("MyTentera ID");
                etFullName.setText(mScanResultItemEntity.getFullName());
                etNIRC.setText(mScanResultItemEntity.getMyTentera());
                myTenteraNric = mScanResultItemEntity.getNric();
                break;

            default:
                break;
        }

        proceedToScanSim();
    }

    public void capture (int type)
    {
        String message = type == 0 ? "Scan a NRIC"
            : type == 1 ? "Scan a Passport"
            : type == 2 ? "Scan a iKad"
            : type == 3 ? "Scan a MyTentera"
            : type == 4 ? "Scan a MyPR"
            : type == 5 ? "Scan a IMM13 Document"
            : type == 6 ? "Scan a Work Permit"
            : type == 7 ? "Scan a Visa"
            : "Scan a SIM Card barcode";

        mStyleableToast = StyleableToast.makeText(getApplicationContext(), message, R.style.StyleToast);

        mTimer = new Timer();
        mTimer.scheduleAtFixedRate(new TimerTask()
        {
            @Override public void run ()
            {
                SIMReplacementAutoActivity.this.runOnUiThread(new Runnable()
                {
                    @Override
                    public void run ()
                    {
                        mStyleableToast.show();
                    }
                });
            }
        }, 0, 3500);

        isActivityExist = true;

        FileUtils.MakeOCRFolder();

        mRecognizerBundle = OCRHelper.get().buildBlinkIdRecognizerElement();

        if (type == 1 || type == 5 ||type == 6 || type == 7)
            mRecognizerBundle = OCRHelper.get().buildMrtdElement();
        else if (type == 8)
            mRecognizerBundle = OCRHelper.get().buildBarCodeElement();

        DocumentUISettings settings = new DocumentUISettings(mRecognizerBundle);
        OCRHelper.get().scan(this, settings,
            type == 8 ? OCR_BARCODE_REQUEST_CODE : OCR_REQUEST_CODE);
    }


    private void proceedToScanSim(){
        FileUtils.ClearOCRFolder();
        mBuffer1 = FileUtils.AddWatermark(mActivity, bufferWithoutWatermark);

        if(! mActivity.isFinishing())
        {
            Glide.with(mActivity)
                    .load(mBuffer1)
                    .diskCacheStrategy(DiskCacheStrategy.NONE)
                    .signature(new StringSignature(System.currentTimeMillis() + ""))
                    .into(ivPhoto1);
        }

        if (isActionFromMenu)
            isActionFromMenu = false;
        else
            capture(8);
    }

    @Override public void onBackPressed ()
    {
        setResult(Constant.ResultCode.USER_CANCELLED);
        super.onBackPressed();
    }

    @Override protected void onDestroy ()
    {
        if (mTimer != null)
        {
            mTimer.purge();
            mTimer.cancel();
        }

        super.onDestroy();
    }
}
