/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.nats.deptreeviz;

import io.gitlab.nats.deptreeviz.ParseInterface;
import io.gitlab.nats.deptreeviz.SimpleWord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleParse
implements ParseInterface<SimpleWord> {
    private List<SimpleWord> words;
    private List<String> levels = new ArrayList<String>();
    private Map<String, List<Integer>> structure;
    private Map<String, List<String>> labels;

    public SimpleParse(List<SimpleWord> words, List<Integer> heads, List<String> labels) {
        this.levels.add("SYN");
        this.words = words;
        this.structure = new HashMap<String, List<Integer>>();
        this.structure.put("SYN", heads);
        this.labels = new HashMap<String, List<String>>();
        this.labels.put("SYN", labels);
    }

    @Override
    public String print() {
        return null;
    }

    @Override
    public List<SimpleWord> getWords() {
        return this.words;
    }

    @Override
    public List<String> getLevels() {
        return this.levels;
    }

    @Override
    public Map<String, List<Integer>> getVerticesStructure() {
        return this.structure;
    }

    @Override
    public Map<String, List<String>> getVerticesLabels() {
        return this.labels;
    }

    @Override
    public void redirectEdge(int pos, String level, int to) {
    }

    public static SimpleParse fromConll(List<String> conll) {
        String line;
        String[] args;
        ArrayList<Integer> heads = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<SimpleWord> words = new ArrayList<SimpleWord>();
        Iterator<String> iterator = conll.iterator();
        while (iterator.hasNext() && (args = (line = iterator.next()).split("\t")).length >= 8) {
            heads.add(Integer.parseInt(args[6]) - 1);
            labels.add(args[7]);
            words.add(new SimpleWord(args[1], args[4]));
        }
        return new SimpleParse(words, heads, labels);
    }
}

