/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.nats.deptreeviz;

import io.gitlab.nats.deptreeviz.DepTree;
import io.gitlab.nats.deptreeviz.DepTreeNode;
import io.gitlab.nats.deptreeviz.ParseInterface;
import io.gitlab.nats.deptreeviz.PopupEvent;
import io.gitlab.nats.deptreeviz.PopupListener;
import io.gitlab.nats.deptreeviz.WordInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class DepTreeBaseInteractor<T extends ParseInterface<E>, E extends WordInterface> {
    public DepTree<T, E> _dt;
    public NodeSelection _selection = new NodeSelection();
    private boolean _deselect = false;
    private EventListenerList _listeners = new EventListenerList();
    private MouseDragAutomaton _mda = new MouseDragAutomaton();
    private Map<Com, Class<? extends DTMouseEventListener>> _mouseEventListeners;
    private EventListenerList _refreshListeners = new EventListenerList();

    protected DepTreeBaseInteractor() {
        this._mouseEventListeners = new HashMap<Com, Class<? extends DTMouseEventListener>>();
        this._mouseEventListeners.put(Com.SELECT, SelectListener.class);
        this._mouseEventListeners.put(Com.CHANGETEXT, ChangeTextListener.class);
        this._mouseEventListeners.put(Com.CONNECT, ConnectListener.class);
    }

    public void draw(boolean isChanged) {
        this._dt.draw(this._dt.getDecParse());
        this.addListeners();
        this._dt.getNodesCanvas().addMouseMotionListener((MouseMotionListener)new DTMouseMotionListener());
        this._dt.getNodesCanvas().addMouseListener((MouseListener)new DTMouseListener());
        this.refreshDisplay(isChanged);
    }

    public void redraw(DepTreeNode node, String level, boolean isChanged) {
        this._dt.redraw();
        this.addListeners();
        if (node == null) {
            this._selection.removeTarget();
        }
        if (this._selection.hasTarget()) {
            this._dt.changeColor(node.getColoringGroup(level), this._dt.getSelectColor());
        }
        this.refreshDisplay(isChanged);
    }

    public void refreshDisplay(boolean isChanged) {
        this._dt.refreshDisplay();
        this.notifyRefresh(isChanged);
    }

    public void addDTRefreshListener(DTRefreshListener listener) {
        this._refreshListeners.add(DTRefreshListener.class, listener);
    }

    private synchronized void notifyRefresh(boolean isChanged) {
        for (DTRefreshListener l : (DTRefreshListener[])this._refreshListeners.getListeners(DTRefreshListener.class)) {
            l.refreshParse(isChanged);
        }
    }

    private void changeLine(double x, double y, Element e) {
        this._dt.getNodesCanvas().getUpdateManager().getUpdateRunnableQueue().invokeLater((Runnable)new ChangeLineRunnable(x, y, e));
    }

    private Dimension adjust(int x, int y) {
        return new Dimension((int)((double)x / this._dt.getZoomFactor()), (int)((double)y / this._dt.getZoomFactor()));
    }

    private void changeCPath(double x, double y, Element e) {
        this._dt.getNodesCanvas().getUpdateManager().getUpdateRunnableQueue().invokeLater((Runnable)new ChangeCPathRunnable(x, y, e));
    }

    private void changeQPath(double x, double y, Element e) {
        this._dt.getNodesCanvas().getUpdateManager().getUpdateRunnableQueue().invokeLater((Runnable)new ChangeQPathRunnable(x, y, e));
    }

    private void changeColor(Color c, Element e) {
        if (e != null) {
            this._dt.getNodesCanvas().getUpdateManager().getUpdateRunnableQueue().invokeLater((Runnable)new ChangeColorRunnable(c, e));
        }
    }

    public void addPopupListener(PopupListener listener) {
        this._listeners.add(PopupListener.class, listener);
    }

    private synchronized void notifySelection(PopupEvent event) {
        for (PopupListener l : (PopupListener[])this._listeners.getListeners(PopupListener.class)) {
            l.makePopup(event);
        }
    }

    private void addListeners() {
        for (DepTreeNode dtNode : this._dt) {
            String currentLevel = this._dt.getCurrentLevel();
            Element dot = dtNode.getElement(DepTree.Elem.DOT, currentLevel);
            this._dt.addElement(dot, Com.SELECT, dtNode, "DEPTREEWORD", true);
            this._dt.addElement(dot, Com.CONNECT, dtNode, currentLevel, true);
            Element hiddendot = dtNode.getElement(DepTree.Elem.HIDDENDOT, currentLevel);
            this._dt.addElement(hiddendot, Com.SELECT, dtNode, "DEPTREEWORD", true);
            this._dt.addElement(hiddendot, Com.CONNECT, dtNode, currentLevel, true);
            Element text = dtNode.getElement(DepTree.Elem.TEXT, "DEPTREEWORD");
            this._dt.addElement(text, Com.SELECT, dtNode, "DEPTREEWORD", true);
            this._dt.addElement(text, Com.CONNECT, dtNode, currentLevel, true);
            this._dt.addElement(text, Com.CHANGETEXT, dtNode, "DEPTREEWORD", true);
            text = dtNode.getElement(DepTree.Elem.HIDDENBOX, "DEPTREEWORD");
            this._dt.addElement(text, Com.SELECT, dtNode, "DEPTREEWORD", true);
            this._dt.addElement(text, Com.CONNECT, dtNode, currentLevel, true);
            this._dt.addElement(text, Com.CHANGETEXT, dtNode, "DEPTREEWORD", true);
            text = dtNode.getElement(DepTree.Elem.TEXT, currentLevel);
            this._dt.addElement(text, Com.CHANGETEXT, dtNode, currentLevel, true);
            this._dt.addElement(text, Com.SELECT, dtNode, currentLevel, true);
            for (String level : this._dt.getLevels()) {
                if (dtNode.getColoringGroup(level) != null) {
                    for (Element e : dtNode.getColoringGroup(level)) {
                        this._dt.addElement(e, Com.SELECT, dtNode, level, true);
                    }
                }
                Element hiddenLine = dtNode.getElement(DepTree.Elem.HIDDENLINE, level);
                this._dt.addElement(hiddenLine, Com.SELECT, dtNode, level, false);
            }
        }
        this.addListeners(true);
        this.addListeners(false);
    }

    private void addListeners(boolean isTarget) {
        for (Com type : Com.values()) {
            for (String level : this._dt.getLevels()) {
                for (DepTreeNode dtNode : this._dt) {
                    ArrayList<Element> elements = this._dt.getElements(type, dtNode, level, isTarget);
                    if (elements == null) continue;
                    for (Element e : elements) {
                        this.addListener(e, type, dtNode, level);
                    }
                }
                ArrayList<Element> elements = this._dt.getElements(type, null, level, isTarget);
                if (elements == null) continue;
                for (Element e : elements) {
                    this.addListener(e, type, null, level);
                }
            }
        }
    }

    private void addListener(Element e, Com com, DepTreeNode dtNode, String level) {
        EventTarget t = (EventTarget)((Object)e);
        DTMouseEventListener listener = null;
        switch (com) {
            case SELECT: {
                listener = this.getSelectListener();
                break;
            }
            case CHANGETEXT: {
                listener = this.getChangeTextListener();
                break;
            }
            case CONNECT: {
                listener = this.getConnectListener();
            }
        }
        listener.setFields(dtNode, level, com);
        t.addEventListener("click", listener, false);
        if (com == Com.SELECT) {
            t.addEventListener("mouseover", listener, false);
            t.addEventListener("mouseout", listener, false);
        }
    }

    private DTMouseEventListener getSelectListener() {
        return new SelectListener();
    }

    protected DTMouseEventListener getChangeTextListener() {
        return new ChangeTextListener();
    }

    private DTMouseEventListener getConnectListener() {
        return new ConnectListener();
    }

    public static abstract class DTMouseEventListener
    implements org.w3c.dom.events.EventListener {
        protected DepTreeNode _node;
        protected String _level;
        Com _type;

        @Override
        public void handleEvent(Event evt) {
            if (evt.getClass().equals(DOMMouseEvent.class)) {
                this.act((DOMMouseEvent)evt);
            }
        }

        public abstract void act(DOMMouseEvent var1);

        public void setFields(DepTreeNode node, String level, Com type) {
            this._node = node;
            this._level = level;
            this._type = type;
        }
    }

    public class NodeSelection {
        boolean _hasTarget = false;
        DepTreeNode _target = null;
        String _level = null;

        public boolean hasTarget() {
            return this._hasTarget;
        }

        public void setHasTarget(boolean hasTarget) {
            this._hasTarget = hasTarget;
        }

        public void setTarget(DepTreeNode target, String level) {
            this._hasTarget = target != null;
            this._target = target;
            this._level = level;
        }

        public void removeTarget() {
            this._hasTarget = false;
            this._target = null;
            this._level = null;
        }
    }

    protected class ConnectListener
    extends DTMouseEventListener {
        protected ConnectListener() {
        }

        @Override
        public void act(DOMMouseEvent devt) {
            if (DepTreeBaseInteractor.this._selection._hasTarget && devt.getButton() == 2) {
                DepTreeNode oldNode = DepTreeBaseInteractor.this._selection._target;
                String oldLevel = DepTreeBaseInteractor.this._selection._level;
                String currentLevel = DepTreeBaseInteractor.this._dt.getCurrentLevel();
                if (oldLevel.equals(currentLevel) && !this._node.getWhoLinks().contains(oldNode.getIndex())) {
                    int newLink = -1;
                    if (this._node.getIndex() != oldNode.getIndex()) {
                        newLink = this._node.getIndex();
                    }
                    oldNode.setLink(oldLevel, newLink);
                    DepTreeBaseInteractor.this._dt.getDecParse().redirectEdge(oldNode.getIndex(), oldLevel, newLink);
                    DepTreeBaseInteractor.this.redraw(oldNode, oldLevel, true);
                } else if ("SYN".equals(currentLevel) && ("DEPTREEWORD".equals(oldLevel) || "REF".equals(oldLevel)) && oldNode.getLink("REF") != this._node.getIndex()) {
                    oldNode.setLink("REF", this._node.getIndex());
                    int refTarget = this._node.getIndex();
                    if (this._node.getIndex() == oldNode.getIndex()) {
                        refTarget = -1;
                        DepTreeBaseInteractor.this._selection._level = "DEPTREEWORD";
                        oldLevel = "DEPTREEWORD";
                    } else {
                        DepTreeBaseInteractor.this._selection._level = "REF";
                        oldLevel = "REF";
                    }
                    DepTreeBaseInteractor.this._dt.getDecParse().redirectEdge(oldNode.getIndex(), "REF", refTarget);
                    DepTreeBaseInteractor.this.redraw(oldNode, oldLevel, true);
                }
            }
        }
    }

    protected class ChangeTextListener
    extends DTMouseEventListener {
        protected ChangeTextListener() {
        }

        @Override
        public void act(DOMMouseEvent devt) {
            if (devt.getButton() == 0) {
                DepTreeBaseInteractor.this.notifySelection(new PopupEvent(this, devt, this._type, this._node, this._level));
            }
        }
    }

    protected class SelectListener
    extends DTMouseEventListener {
        protected SelectListener() {
        }

        @Override
        public void act(DOMMouseEvent devt) {
            if ("mouseout".equals(devt.getType())) {
                DepTreeBaseInteractor.this._mda.moveOut(this._node, this._level);
            } else if ("mouseover".equals(devt.getType())) {
                DepTreeBaseInteractor.this._mda.moveIn(this._node, this._level);
            }
            if (devt.getButton() == 0 && "click".equals(devt.getType())) {
                DepTreeBaseInteractor.this._deselect = false;
                if (DepTreeBaseInteractor.this._selection.hasTarget()) {
                    DepTreeNode node = DepTreeBaseInteractor.this._selection._target;
                    DepTreeBaseInteractor.this._dt.changeColor(node.getColoringGroup(DepTreeBaseInteractor.this._selection._level), Color.black);
                    DepTreeBaseInteractor.this._dt.highlight(node);
                    if (node == this._node && this._level.equals(DepTreeBaseInteractor.this._selection._level)) {
                        DepTreeBaseInteractor.this._deselect = true;
                        DepTreeBaseInteractor.this._selection.setTarget(null, null);
                    }
                }
                if (!DepTreeBaseInteractor.this._deselect) {
                    DepTreeBaseInteractor.this._selection.setTarget(this._node, this._level);
                    DepTreeBaseInteractor.this._dt.changeColor(this._node.getColoringGroup(DepTreeBaseInteractor.this._selection._level), DepTreeBaseInteractor.this._dt.getSelectColor());
                    DepTreeBaseInteractor.this._deselect = true;
                }
            }
        }
    }

    private class DTMouseMotionListener
    implements MouseMotionListener {
        private DTMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mevt) {
            DepTreeBaseInteractor.this._mda.dragMouse(mevt.getX(), mevt.getY());
        }

        @Override
        public void mouseMoved(MouseEvent mevt) {
        }
    }

    private class ChangeColorRunnable
    implements Runnable {
        Color _c;
        Element _e;

        public ChangeColorRunnable(Color c, Element e) {
            this._c = c;
            this._e = e;
        }

        @Override
        public void run() {
            String color = "rgb(" + this._c.getRed() + "," + this._c.getGreen() + "," + this._c.getBlue() + ")";
            Element parent = (Element)this._e.getParentNode();
            parent.setAttribute("fill", color);
            parent.setAttribute("fill-opacity", String.valueOf(this._c.getAlpha() / 255));
            parent.setAttribute("stroke", String.valueOf(color));
            parent.setAttribute("stroke-opacity", String.valueOf(this._c.getAlpha() / 255));
        }
    }

    private class ChangeQPathRunnable
    implements Runnable {
        double _x;
        double _y;
        Element _e;

        public ChangeQPathRunnable(double x, double y, Element e) {
            this._x = x;
            this._y = y;
            this._e = e;
        }

        @Override
        public void run() {
            String[] list = this._e.getAttribute("d").split("C");
            this._e.setAttribute("d", "M" + this._x + " " + this._y + "C" + list[1]);
        }
    }

    private class ChangeCPathRunnable
    implements Runnable {
        double _x;
        double _y;
        Element _e;

        public ChangeCPathRunnable(double x, double y, Element e) {
            this._x = x;
            this._y = y;
            this._e = e;
        }

        @Override
        public void run() {
            String[] list = this._e.getAttribute("d").split("C");
            this._e.setAttribute("d", "M" + this._x + " " + this._y + "C" + list[1]);
        }
    }

    private class ChangeLineRunnable
    implements Runnable {
        double _x;
        double _y;
        Element _e;

        public ChangeLineRunnable(double x, double y, Element e) {
            this._x = x;
            this._y = y;
            this._e = e;
        }

        @Override
        public void run() {
            this._e.setAttribute("x2", String.valueOf(this._x));
            this._e.setAttribute("y2", String.valueOf(this._y));
        }
    }

    private class DTMouseListener
    implements MouseListener {
        private DTMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mevt) {
        }

        @Override
        public void mouseEntered(MouseEvent mevt) {
        }

        @Override
        public void mouseExited(MouseEvent mevt) {
        }

        @Override
        public void mousePressed(MouseEvent mevt) {
            DepTreeBaseInteractor.this._mda.buttonPressed(mevt.getButton());
        }

        @Override
        public void mouseReleased(MouseEvent mevt) {
            DepTreeBaseInteractor.this._mda.buttonReleased(mevt.getButton());
            if (DepTreeBaseInteractor.this._deselect) {
                // empty if block
            }
        }
    }

    private class MouseDragAutomaton {
        MDAState _state = MDAState.NODRAG;
        DepTreeNode _targetNode = null;
        String _targetLevel = null;
        boolean _hasTarget = false;
        DepTreeNode _draggedNode = null;
        String _draggedLevel = null;
        int _button = 0;

        public void moveIn(DepTreeNode node, String level) {
            this._hasTarget = true;
            this._targetNode = node;
            this._targetLevel = level;
            switch (this._state) {
                case NODRAG: {
                    DepTreeBaseInteractor.this._dt.changeColor(node.getColoringGroup(level), DepTreeBaseInteractor.this._dt.getMouseoverColor());
                }
            }
        }

        public void moveOut(DepTreeNode node, String level) {
            if (node.equals(this._targetNode) && level.equals(this._targetLevel)) {
                this._hasTarget = false;
                this._targetNode = null;
                this._targetLevel = null;
                DepTreeBaseInteractor.this._dt.changeColor(node.getColoringGroup(level), Color.black);
                DepTreeBaseInteractor.this._dt.highlight(node);
                DepTreeNode selectionNode = DepTreeBaseInteractor.this._selection._target;
                if (selectionNode != null) {
                    DepTreeBaseInteractor.this._dt.changeColor(selectionNode.getColoringGroup(DepTreeBaseInteractor.this._selection._level), DepTreeBaseInteractor.this._dt.getSelectColor());
                }
            }
        }

        public void dragMouse(Integer x, Integer y) {
            if (this._button == 1) {
                Dimension d = DepTreeBaseInteractor.this.adjust(x, y);
                x = d.width;
                y = d.height;
                switch (this._state) {
                    case NODRAG: {
                        if (this._hasTarget && !"DEPTREEWORD".equals(this._targetLevel)) {
                            this._state = MDAState.DRAGELEM;
                            this._draggedNode = this._targetNode;
                            this._draggedLevel = this._targetLevel;
                            break;
                        }
                        this._state = MDAState.DRAGNONE;
                        break;
                    }
                    case DRAGELEM: {
                        if (this._draggedLevel.equals(DepTreeBaseInteractor.this._dt.getCurrentLevel())) {
                            Element t = this._draggedNode.getElement(DepTree.Elem.TEXT, this._draggedLevel);
                            DepTreeBaseInteractor.this.changeColor(DepTree.invisible, t);
                            if (this._draggedNode.linkIsRoot(this._draggedLevel)) {
                                Element e = this._draggedNode.getElement(DepTree.Elem.LINE, this._draggedLevel);
                                DepTreeBaseInteractor.this.changeLine(x.intValue(), y.intValue(), e);
                                break;
                            }
                            if (this._draggedNode.getY() > DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(DepTreeBaseInteractor.this._dt.getCurrentLevel())).getY()) {
                                Element e = this._draggedNode.getElement(DepTree.Elem.LINE, this._draggedLevel);
                                DepTreeBaseInteractor.this.changeLine(x.intValue(), y.intValue(), e);
                                break;
                            }
                            Element e = this._draggedNode.getElement(DepTree.Elem.LINE, this._draggedLevel);
                            DepTreeBaseInteractor.this.changeCPath(x.intValue(), y.intValue(), e);
                            break;
                        }
                        Element e = this._draggedNode.getElement(DepTree.Elem.LINE, this._draggedLevel);
                        DepTreeBaseInteractor.this.changeQPath(x.intValue(), y.intValue(), e);
                        Element al1 = this._draggedNode.getElement(DepTree.Elem.ARROWLINE1, this._draggedLevel);
                        DepTreeBaseInteractor.this.changeColor(DepTree.invisible, al1);
                        Element al2 = this._draggedNode.getElement(DepTree.Elem.ARROWLINE2, this._draggedLevel);
                        DepTreeBaseInteractor.this.changeColor(DepTree.invisible, al2);
                    }
                }
            }
        }

        public void buttonReleased(int button) {
            this._button = button;
            if (this._button == 1) {
                switch (this._state) {
                    case DRAGELEM: {
                        Element e = this._draggedNode.getElement(DepTree.Elem.LINE, this._draggedLevel);
                        if (this._hasTarget && "DEPTREEWORD".equals(this._targetLevel)) {
                            this._state = MDAState.NODRAG;
                            this._hasTarget = false;
                            int newLink = -1;
                            if (this._targetNode.getIndex() != this._draggedNode.getIndex()) {
                                newLink = this._targetNode.getIndex();
                            }
                            this._draggedNode.setLink(this._targetLevel, newLink);
                            DepTreeBaseInteractor.this._dt.getDecParse().redirectEdge(this._draggedNode.getIndex(), this._draggedLevel, newLink);
                            DepTreeBaseInteractor.this.redraw(this._draggedNode, this._draggedLevel, true);
                            break;
                        }
                        this._state = MDAState.NODRAG;
                        this._hasTarget = false;
                        if (this._draggedLevel.equals(DepTreeBaseInteractor.this._dt.getCurrentLevel())) {
                            Element t = this._draggedNode.getElement(DepTree.Elem.TEXT, this._draggedLevel);
                            DepTreeBaseInteractor.this.changeColor(DepTreeBaseInteractor.this._dt.getSelectColor(), t);
                            if (this._draggedNode.linkIsRoot(this._draggedLevel)) {
                                DepTreeBaseInteractor.this.changeLine(this._draggedNode.getX(), DepTreeBaseInteractor.this._dt.getMinY(), e);
                                break;
                            }
                            if (this._draggedNode.getY() > DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(DepTreeBaseInteractor.this._dt.getCurrentLevel())).getY()) {
                                DepTreeBaseInteractor.this.changeLine(DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(this._draggedLevel)).getX(), DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(this._draggedLevel)).getY(), e);
                                break;
                            }
                            DepTreeBaseInteractor.this.changeCPath(DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(this._draggedLevel)).getX(), DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(this._draggedLevel)).getY(), e);
                            break;
                        }
                        double linkedNodeXPos = DepTreeBaseInteractor.this._dt.getNode(this._draggedNode.getLink(this._draggedLevel)).getX();
                        int arrowHeadWidth = 1 + DepTreeBaseInteractor.this._dt.getLineThickness();
                        linkedNodeXPos = linkedNodeXPos < this._draggedNode.getX() ? (linkedNodeXPos += (double)arrowHeadWidth) : (linkedNodeXPos -= (double)arrowHeadWidth);
                        DepTreeBaseInteractor.this.changeQPath(linkedNodeXPos, DepTreeBaseInteractor.this._dt.getNonCurrentYs().get(this._draggedNode.getNonCurrentYLevel(this._draggedLevel) - 1), e);
                        Element al1 = this._draggedNode.getElement(DepTree.Elem.ARROWLINE1, this._draggedLevel);
                        DepTreeBaseInteractor.this.changeColor(DepTreeBaseInteractor.this._dt.getSelectColor(), al1);
                        Element al2 = this._draggedNode.getElement(DepTree.Elem.ARROWLINE2, this._draggedLevel);
                        DepTreeBaseInteractor.this.changeColor(DepTreeBaseInteractor.this._dt.getSelectColor(), al2);
                        break;
                    }
                    case DRAGNONE: {
                        this._state = MDAState.NODRAG;
                    }
                }
            }
        }

        public void buttonPressed(int button) {
            switch (this._state) {
                case NODRAG: {
                    this._button = button;
                }
            }
        }
    }

    public static interface DTRefreshListener
    extends EventListener {
        public void refreshParse(boolean var1);
    }

    private static enum MDAState {
        NODRAG,
        DRAGELEM,
        DRAGNONE;

    }

    public static enum Com {
        SELECT,
        CONNECT,
        CHANGETEXT,
        HIGHLIGHT,
        DEMO;

    }
}

