/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.nats.deptreeviz;

import io.gitlab.nats.deptreeviz.DepTree;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;

public class DepTreeNode {
    private String _word;
    private int _index;
    private HashMap<String, Integer> _links = new HashMap();
    private HashMap<String, String> _labels = new HashMap();
    private HashMap<ElementID, Element> _elements = new HashMap();
    private HashMap<String, ArrayList<Element>> _coloringGroup = new HashMap();
    private boolean _top;
    private boolean _isInCircle;
    private ArrayList<String> _markedLevels;
    private double _x;
    private double _y;
    private ArrayList<Integer> whoLinks;
    private HashMap<String, Integer> _nonCurrentYLevel;
    private HashMap<String, Rectangle2D> _nonCurrentLabelBorders;

    public DepTreeNode(String w) {
        this._word = w;
    }

    public void init(ArrayList<String> levels) {
        for (String level : levels) {
            this.setLink(level, -1);
            this.setLabel(level, "");
        }
        this.setIsTop(false);
        this.setIsInCircle(false);
        this.setMarkedLevels(null);
        this.setX(0.0);
        this.setY(0.0);
        this._nonCurrentYLevel = new HashMap();
        this._nonCurrentLabelBorders = new HashMap();
        this.setWhoLinks(new ArrayList<Integer>());
        this._coloringGroup = new HashMap();
    }

    public boolean linkIsRoot(String level) {
        return this._links.get(level) == -1 || this._links.get(level) == -2;
    }

    public void setLink(String level, int synLink) {
        this._links.put(level, synLink);
    }

    public int getLink(String level) {
        return this._links.get(level);
    }

    public void setElement(Element element, DepTree.Elem type, String level) {
        ElementID id = new ElementID(type, level);
        this._elements.put(id, element);
    }

    public Element getElement(DepTree.Elem type, String level) {
        ElementID id = new ElementID(type, level);
        return this._elements.get(id);
    }

    public void addToColoringGroup(Element element, String level) {
        ArrayList<Element> elements = this._coloringGroup.get(level);
        if (elements == null) {
            elements = new ArrayList();
            this._coloringGroup.put(level, elements);
        }
        elements.add(element);
    }

    public void setLabel(String level, String label) {
        this._labels.put(level, label);
    }

    public String getLabel(String level) {
        return this._labels.get(level);
    }

    public ArrayList<Element> getColoringGroup(String level) {
        return this._coloringGroup.get(level);
    }

    public void setWord(String _word) {
        this._word = _word;
    }

    public String getWord() {
        return this._word;
    }

    public void setIndex(int _index) {
        this._index = _index;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIsTop(boolean top) {
        this._top = top;
    }

    public boolean isTop() {
        return this._top;
    }

    public void setIsInCircle(boolean isInCircle) {
        this._isInCircle = isInCircle;
    }

    public boolean isInCircle() {
        return this._isInCircle;
    }

    public void setMarkedLevels(ArrayList<String> markedLevels) {
        this._markedLevels = markedLevels;
    }

    public ArrayList<String> getMarkedLevels() {
        return this._markedLevels;
    }

    public void setX(double x) {
        this._x = x;
    }

    public double getX() {
        return this._x;
    }

    public void setY(double y) {
        this._y = y;
    }

    public double getY() {
        return this._y;
    }

    public void setWhoLinks(ArrayList<Integer> whoLinks) {
        this.whoLinks = whoLinks;
    }

    public ArrayList<Integer> getWhoLinks() {
        return this.whoLinks;
    }

    public int getNonCurrentYLevel(String level) {
        Integer result = this._nonCurrentYLevel.get(level);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public void setNonCurrentYLevel(int nonCurrentYLevel, String level) {
        this._nonCurrentYLevel.put(level, nonCurrentYLevel);
    }

    public Rectangle2D getNonCurrentLabelBorder(String level) {
        return this._nonCurrentLabelBorders.get(level);
    }

    public void setNonCurrentLabelBorder(Rectangle2D nonCurrentYLabelBorder, String level) {
        this._nonCurrentLabelBorders.put(level, nonCurrentYLabelBorder);
    }

    private class ElementID {
        DepTree.Elem _type;
        String _level;

        public ElementID(DepTree.Elem type, String level) {
            this._type = type;
            this._level = level;
        }

        public boolean equals(Object o) {
            if (o.getClass() == ElementID.class) {
                ElementID id = (ElementID)o;
                return this.equals(id);
            }
            return false;
        }

        public boolean equals(ElementID id) {
            return this._type.equals((Object)id._type) && this._level.equals(id._level);
        }

        public int hashCode() {
            return this._type.hashCode() + this._level.hashCode();
        }
    }
}

