/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.nats.deptreeviz;

import io.gitlab.nats.deptreeviz.DepTreeBaseInteractor;
import io.gitlab.nats.deptreeviz.DepTreeNode;
import io.gitlab.nats.deptreeviz.ParseInterface;
import io.gitlab.nats.deptreeviz.WordInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.UpdateManagerAdapter;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class DepTree<T extends ParseInterface<E>, E extends WordInterface>
implements Iterable<DepTreeNode> {
    private ArrayList<DepTreeNode> _wordNodes = new ArrayList();
    private T _parse;
    private HashMap<CommandID, ArrayList<Element>> _comElements = new HashMap();
    private ArrayList<String> _levels = new ArrayList();
    private Map<String, List<String>> _verticesLabels;
    private Map<String, List<Integer>> _verticesStructure;
    private String _currentLevel = "SYN";
    private SVGDocument _doc;
    private int _lineThickness = 2;
    private int _selectThickness = 20;
    private Color _mouseoverColor = new Color(128, 128, 128);
    private Dimension _windowSize;
    private Dimension _canvasSize = this._windowSize = new Dimension(1100, 900);
    private Color _highlightColor = new Color(0, 128, 0);
    private Color _selectColor = new Color(128, 128, 255);
    private Color _transparentColor = transWhite;
    private Font _font = new Font("Dialog.plain", 0, 16);
    private static Color darkRed = new Color(128, 0, 0);
    public static Color transWhite = new Color(255, 255, 255, 128);
    public static Color invisible = new Color(0, 0, 0, 0);
    private boolean _droppingLeaves = false;
    private boolean _showingCat = true;
    private boolean _showingReferent = false;
    private boolean _drawingRoot = true;
    private boolean _parsingIncrementally = true;
    private boolean _drawingBoxes = true;
    private BoxType _boxType = BoxType.SIMPLE;
    private double _currentYLength = 55.0;
    private double _refYLength = this._font.getSize() * 2 + 50;
    private int _minX = 10;
    private double _minY = 15 + this._font.getSize() / 2;
    private double _maxY;
    private double _belowTreeY;
    private double _zoomFactor = 1.0;
    private Map<Integer, ArrayList<String>> _markedNodes;
    private Path2D.Double _transparentBoxes = new Path2D.Double();
    private Stroke _lineStroke;
    private Stroke _selectStroke;
    private Stroke _beforeStroke;
    private SVGGraphics2D _SVGGen;
    private JSVGCanvas _nodesCanvas;
    private boolean _busy = false;
    private boolean _overlapping = false;
    private ArrayList<DepTreeNode> _forestTODO;
    private ArrayList<DepTreeNode> _nodesTODO;
    private ArrayList<DepTreeNode> _circleTODO;
    private ArrayList<Double> _nonCurrentYs = new ArrayList();

    public DepTree() {
    }

    private DepTree(Map<Integer, ArrayList<String>> markedNodes) {
        this();
        this._markedNodes = markedNodes;
    }

    public DepTree(Map<Integer, ArrayList<String>> markedNodes, int windowSizeX, int windowSizeY, int lineThickness, Color highlightColor, Color selectColor, Font font) {
        this(markedNodes);
        this._lineThickness = lineThickness;
        this._highlightColor = highlightColor;
        this._font = font;
        this._windowSize = new Dimension(windowSizeX, windowSizeY);
        this._selectColor = selectColor;
    }

    public DepTree(T parse) {
        this(parse, null);
    }

    public DepTree(T parse, Map<Integer, ArrayList<String>> markedNodes) {
        this(markedNodes);
        this.setShowingCat(false);
        this.draw((Map<Integer, ArrayList<String>>)parse);
        this.refreshDisplay();
    }

    @Override
    public Iterator<DepTreeNode> iterator() {
        return this._wordNodes.iterator();
    }

    private void add(int i, DepTreeNode node) {
        this._wordNodes.add(i, node);
    }

    public DepTreeNode getNode(int i) {
        return this._wordNodes.get(i);
    }

    void addElement(Element element, DepTreeBaseInteractor.Com type, DepTreeNode node, String level, boolean isTarget) {
        if (element != null) {
            element = (Element)element.getParentNode();
            CommandID id = new CommandID(type, node, level, isTarget);
            ArrayList<Element> elements = this._comElements.get(id);
            if (elements == null) {
                elements = new ArrayList();
                this._comElements.put(id, elements);
            }
            elements.add(element);
        }
    }

    public ArrayList<Element> getElements(DepTreeBaseInteractor.Com type, DepTreeNode node, String level, boolean isTarget) {
        CommandID id = new CommandID(type, node, level, isTarget);
        return this._comElements.get(id);
    }

    private Element getCurrentElement() {
        return (Element)this._doc.getLastChild().getLastChild().getLastChild().getLastChild();
    }

    private void initCommands() {
        this._comElements = new HashMap();
    }

    private void setFields(T parse) {
        this.setFields(parse.getLevels(), parse.getVerticesLabels(), parse.getVerticesStructure());
    }

    private void setFields(List<String> levels, Map<String, List<String>> verticesLabels, Map<String, List<Integer>> verticesStructure) {
        this._levels = new ArrayList();
        this._levels.addAll(levels);
        this._levels.add("DEPTREEWORD");
        this._levels.add("DEPTREE");
        this._verticesLabels = verticesLabels;
        this._verticesStructure = verticesStructure;
    }

    private void emptyWordNodes() {
        this._wordNodes = new ArrayList();
    }

    public void refreshDisplay() {
        if (this._nodesCanvas != null) {
            this._nodesCanvas.setSVGDocument(this._doc);
        }
    }

    private String getCat(DepTreeNode node) {
        return ((WordInterface)this.getDecParse().getWords().get(node.getIndex())).getFeature("cat");
    }

    private String getReferent(DepTreeNode node) {
        return "Referent_" + node.getIndex();
    }

    public void setLevels(ArrayList<String> levels) {
        this._levels = levels;
    }

    public ArrayList<String> getLevels() {
        return this._levels;
    }

    public void setVerticesLabels(Map<String, List<String>> verticesLabels) {
        this._verticesLabels = verticesLabels;
    }

    private Map<String, List<String>> getVerticesLabels() {
        return this._verticesLabels;
    }

    public void setVerticesStructure(Map<String, List<Integer>> verticesStructure) {
        this._verticesStructure = verticesStructure;
    }

    private Map<String, List<Integer>> getVerticesStructure() {
        return this._verticesStructure;
    }

    private void setDoc(SVGDocument doc) {
        this._doc = doc;
    }

    public SVGDocument getDoc() {
        return this._doc;
    }

    public void setSelectThickness(int selectThickness) {
        this._selectThickness = selectThickness;
    }

    private int getSelectThickness() {
        return this._selectThickness;
    }

    public void setMouseoverColor(Color mouseoverColor) {
        this._mouseoverColor = mouseoverColor;
    }

    public Color getMouseoverColor() {
        return this._mouseoverColor;
    }

    public void setLineThickness(int lineThickness) {
        this._lineThickness = lineThickness;
    }

    public int getLineThickness() {
        return this._lineThickness;
    }

    private void setCanvasSizeX(int canvasSizeX) {
        this._canvasSize = new Dimension((int)((double)canvasSizeX * this._zoomFactor), this._canvasSize.height);
    }

    private int getCanvasSizeX() {
        return this._canvasSize.width;
    }

    private void setCanvasSizeY(int canvasSizeY) {
        this._canvasSize = new Dimension(this._canvasSize.width, (int)((double)canvasSizeY * this._zoomFactor));
    }

    public int getCanvasSizeY() {
        return this._canvasSize.height;
    }

    public void setWindowSize(Dimension windowSize) {
        this._windowSize = windowSize;
    }

    public Dimension getWindowSize() {
        return this._windowSize;
    }

    private void setCanvasSize(Dimension canvasSize) {
        this._canvasSize = canvasSize;
    }

    public Dimension getCanvasSize() {
        return this._canvasSize;
    }

    public void setHighlightColor(Color highlightColor) {
        this._highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public void setSelectColor(Color selectColor) {
        this._selectColor = selectColor;
    }

    public Color getSelectColor() {
        return this._selectColor;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public Font getFont() {
        return this._font;
    }

    public void setCurrentYLength(double currentYLength) {
        this._currentYLength = currentYLength;
    }

    public double getCurrentYLength() {
        return this._currentYLength;
    }

    public void setREFYLength(double refYLength) {
        this._refYLength = refYLength;
    }

    public double getREFYLength() {
        return this._refYLength;
    }

    public void setMinX(int minX) {
        this._minX = minX;
    }

    private int getMinX() {
        return this._minX;
    }

    public void setMinY(double minY) {
        this._minY = minY;
    }

    public double getMinY() {
        return this._minY;
    }

    private void setMaxY(double maxY) {
        this._maxY = maxY;
    }

    private double getMaxY() {
        return this._maxY;
    }

    private void setBelowTreeY(double _belowTreeY) {
        this._belowTreeY = _belowTreeY;
    }

    private double getBelowTreeY() {
        return this._belowTreeY;
    }

    public void setMarkedNodes(Map<Integer, ArrayList<String>> markedNodes) {
        this._markedNodes = markedNodes;
    }

    public void resetMarkedNodes() {
        this._markedNodes = null;
    }

    public Map<Integer, ArrayList<String>> getMarkedNodes() {
        return this._markedNodes;
    }

    private void setLineStroke(Stroke lineStroke) {
        this._lineStroke = lineStroke;
    }

    private Stroke getLineStroke() {
        return this._lineStroke;
    }

    private void setSelectStroke(Stroke selectStroke) {
        this._selectStroke = selectStroke;
    }

    private Stroke getSelectStroke() {
        return this._selectStroke;
    }

    private void setBeforeStroke(Stroke beforeStroke) {
        this._beforeStroke = beforeStroke;
    }

    private Stroke getBeforeStroke() {
        return this._beforeStroke;
    }

    private void set_nodesCanvas(JSVGCanvas nodesCanvas) {
        this._nodesCanvas = nodesCanvas;
        this._nodesCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                DepTree.this._busy = true;
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                DepTree.this._busy = false;
            }
        });
        this._nodesCanvas.addUpdateManagerListener((UpdateManagerListener)new UpdateManagerAdapter(){

            public void updateStarted(UpdateManagerEvent e) {
                DepTree.this._busy = false;
            }
        });
        this._nodesCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                DepTree.this._busy = true;
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                DepTree.this._busy = false;
            }
        });
        this._nodesCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                DepTree.this._busy = true;
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                DepTree.this._busy = false;
            }
        });
    }

    public JSVGCanvas getNodesCanvas() {
        return this._nodesCanvas;
    }

    private void setForestTODO(ArrayList<DepTreeNode> forestTODO) {
        this._forestTODO = forestTODO;
    }

    private void setNodesTODO(ArrayList<DepTreeNode> nodesTODO) {
        this._nodesTODO = nodesTODO;
    }

    private void setCircleTODO(ArrayList<DepTreeNode> circleTODO) {
        this._circleTODO = circleTODO;
    }

    private ArrayList<DepTreeNode> getCircleTODO() {
        return this._circleTODO;
    }

    public void setCurrentLevel(String currentLevel) {
        this._currentLevel = currentLevel;
    }

    public String getCurrentLevel() {
        return this._currentLevel;
    }

    private void addNonCurrentY(double nonCurrentY) {
        if (this._nonCurrentYs.size() == 0) {
            this._nonCurrentYs.add(nonCurrentY);
        } else if (nonCurrentY > this._nonCurrentYs.get(this._nonCurrentYs.size() - 1)) {
            this._nonCurrentYs.add(nonCurrentY);
        }
    }

    public ArrayList<Double> getNonCurrentYs() {
        return this._nonCurrentYs;
    }

    private void resetNonCurrentYs() {
        this._nonCurrentYs = new ArrayList();
        for (DepTreeNode iNode : this) {
            for (String level : this.getLevels()) {
                iNode.setNonCurrentYLevel(0, level);
            }
        }
    }

    public boolean isDroppingLeaves() {
        return this._droppingLeaves;
    }

    public void setDroppingLeaves(boolean droppingLeaves) {
        this._droppingLeaves = droppingLeaves;
    }

    public boolean isShowingCat() {
        return this._showingCat;
    }

    public void setShowingCat(boolean showingCat) {
        this._showingCat = showingCat;
    }

    public T getDecParse() {
        return this._parse;
    }

    public void setDecParse(T decParse) {
        this._parse = decParse;
    }

    public double getZoomFactor() {
        return this._zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this._zoomFactor = zoomFactor;
    }

    private void doZoom() {
        this._SVGGen.scale(this._zoomFactor, this._zoomFactor);
    }

    public boolean isDrawingRoots() {
        return this._drawingRoot;
    }

    public void setDrawingRoots(boolean drawRoot) {
        this._drawingRoot = drawRoot;
    }

    public Color getTransparentColor() {
        return this._transparentColor;
    }

    public void setTransparentColor(Color transparentColor) {
        this._transparentColor = transparentColor;
    }

    public boolean isParsingIncrementally() {
        return this._parsingIncrementally;
    }

    public void setParsingIncrementally(boolean parsingIncrementally) {
        this._parsingIncrementally = parsingIncrementally;
    }

    private Path2D.Double getTransparentBoxes() {
        return this._transparentBoxes;
    }

    public void resetTransparentBoxes(Area visibleArea) {
        this._transparentBoxes = new Path2D.Double();
    }

    public void addToTransparentBoxes(Shape shape) {
        this._transparentBoxes.append(shape, false);
    }

    private boolean isDrawingBoxes() {
        return this._drawingBoxes;
    }

    public void setDrawingBoxes(boolean drawingBoxes) {
        this._drawingBoxes = drawingBoxes;
    }

    private BoxType getBoxType() {
        return this._boxType;
    }

    public void setBoxType(BoxType boxType) {
        this._boxType = boxType;
    }

    public boolean isBusy() {
        return this._busy;
    }

    public void setBusy(boolean busy) {
        this._busy = busy;
    }

    public boolean isShowingReferent() {
        return this._showingReferent;
    }

    public void setShowingReferent(boolean showingReferent) {
        this._showingReferent = showingReferent;
    }

    private boolean isOverlapping() {
        return this._overlapping;
    }

    private void setOverlapping(boolean overlapping) {
        this._overlapping = overlapping;
    }

    public void draw(T parse) {
        if (parse == null) {
            this.initGraph();
        } else {
            this.setFields(parse);
            this.generateWordNodes(parse);
            this.initGraph();
            this.initWordNodes();
            this.setYPositions(this._forestTODO, this._nodesTODO);
            this.buildCircles();
            this.dropLeaves();
            this.drawNodes();
        }
    }

    public void redraw() {
        this.reinitGraph();
        this.initWordNodes();
        this.setYPositions(this._forestTODO, this._nodesTODO);
        this.buildCircles();
        this.dropLeaves();
        this.drawNodes();
    }

    private void initGraph() {
        this.initCommands();
        this.setForestTODO(new ArrayList<DepTreeNode>());
        this.setNodesTODO(new ArrayList<DepTreeNode>());
        this.setCircleTODO(new ArrayList<DepTreeNode>());
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.setDoc((SVGDocument)impl.createDocument(svgNS, "svg", null));
        this._SVGGen = new SVGGraphics2D((Document)this.getDoc());
        this.set_nodesCanvas(new JSVGCanvas());
        this.getNodesCanvas().setSVGDocument(this.getDoc());
        this._SVGGen.setFont(this._font);
        this.passContent();
    }

    private void reinitGraph() {
        this.initCommands();
        this.setForestTODO(new ArrayList<DepTreeNode>());
        this.setNodesTODO(new ArrayList<DepTreeNode>());
        this.setCircleTODO(new ArrayList<DepTreeNode>());
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.setDoc((SVGDocument)impl.createDocument(svgNS, "svg", null));
        this.getNodesCanvas().setSVGDocument(this.getDoc());
        this._SVGGen = new SVGGraphics2D((Document)this.getDoc());
        this._SVGGen.setFont(this._font);
        this.passContent();
    }

    private void generateWordNodes(T parse) {
        this.emptyWordNodes();
        List words = parse.getWords();
        for (int i = 0; i < words.size(); ++i) {
            WordInterface word = (WordInterface)words.get(i);
            DepTreeNode node = new DepTreeNode(word.getWord());
            node.setIndex(i);
            this.add(i, node);
        }
    }

    private void generateWordNodes(List<String> words) {
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            DepTreeNode node = new DepTreeNode(word);
            node.setIndex(i);
            this.add(i, node);
        }
    }

    private void initWordNodes() {
        this.setMaxY(this.getCurrentYLength());
        this.setLineStroke(new BasicStroke(this.getLineThickness()));
        this.setSelectStroke(new BasicStroke(this.getSelectThickness()));
        double iNodeX = this._font.getSize() + this.getMinX();
        if (this.getMarkedNodes() == null) {
            this.setMarkedNodes(new HashMap<Integer, ArrayList<String>>());
        }
        for (DepTreeNode node : this) {
            Rectangle2D referentBorder;
            Rectangle2D catBorder;
            node.init(this.getLevels());
            node.setMarkedLevels(this.getMarkedNodes().get(node.getIndex()));
            Rectangle2D wordBorder = this._font.getStringBounds(node.getWord(), this._SVGGen.getFontRenderContext());
            if (this.isShowingCat() && (catBorder = this._font.getStringBounds(this.getCat(node), this._SVGGen.getFontRenderContext())).getMaxX() > wordBorder.getMaxX()) {
                wordBorder = catBorder;
            }
            if (this.isShowingReferent() && (referentBorder = this._font.getStringBounds(this.getReferent(node), this._SVGGen.getFontRenderContext())).getMaxX() > wordBorder.getMaxX()) {
                wordBorder = referentBorder;
            }
            Rectangle2D spaceBorder = this._font.getStringBounds("      ", this._SVGGen.getFontRenderContext());
            double wordLength = spaceBorder.getMaxX() + wordBorder.getMaxX();
            node.setX(iNodeX + wordBorder.getCenterX());
            node.setY(this.getMinY());
            if (this.isDrawingRoots()) {
                node.setY(this.getCurrentYLength() + node.getY());
            }
            this.setCanvasSizeX((int)((iNodeX += wordLength) + wordBorder.getMaxX() + (double)this.getLineThickness() + 1.0));
            for (String level : this.getLevels()) {
                if (level.startsWith("DEPTREE")) continue;
                node.setLabel(level, this.getVerticesLabels().get(level).get(node.getIndex()));
                node.setLink(level, this.getVerticesStructure().get(level).get(node.getIndex()));
            }
            if (!node.linkIsRoot(this.getCurrentLevel())) continue;
            this._forestTODO.add(node);
            node.setIsTop(true);
        }
        for (DepTreeNode nodeA : this) {
            if (nodeA.isTop()) continue;
            DepTreeNode nodeB = this.getNode(nodeA.getLink(this.getCurrentLevel()));
            ArrayList<Integer> whoLinks = nodeB.getWhoLinks();
            if (whoLinks == null) {
                whoLinks = new ArrayList();
                nodeB.setWhoLinks(whoLinks);
            }
            whoLinks.add(nodeA.getIndex());
            this._nodesTODO.add(nodeA);
        }
    }

    private void setYPositions(ArrayList<DepTreeNode> forestTODO, ArrayList<DepTreeNode> restTODO) {
        while (!forestTODO.isEmpty()) {
            DepTreeNode node = forestTODO.get(0);
            ArrayList<Integer> whoLinks = node.getWhoLinks();
            this.setMaxY(Math.max(this.getMaxY(), node.getY()));
            for (Integer ID : whoLinks) {
                DepTreeNode nextNode = this.getNode(ID);
                if (!nextNode.isTop()) {
                    nextNode.setY(node.getY() + this.getCurrentYLength());
                    forestTODO.add(nextNode);
                }
                restTODO.remove(nextNode);
            }
            forestTODO.remove(node);
        }
    }

    private void buildCircles() {
        while (!this._nodesTODO.isEmpty()) {
            DepTreeNode node = this._nodesTODO.get(0);
            while (!node.isInCircle()) {
                node.setIsInCircle(true);
                node = this.getNode(node.getLink(this.getCurrentLevel()));
            }
            this._nodesTODO.remove(node);
            this.getCircleTODO().add(node);
            node.setIsTop(true);
            this.setYPositions(this.getCircleTODO(), this._nodesTODO);
        }
    }

    private void dropLeaves() {
        if (this.isDroppingLeaves()) {
            for (DepTreeNode node : this) {
                if (!node.getWhoLinks().isEmpty() || node.isTop()) continue;
                node.setY(this.getMaxY());
                for (Integer brotherID : this.getNode(node.getLink(this.getCurrentLevel())).getWhoLinks()) {
                    DepTreeNode brother = this.getNode(brotherID);
                    if (!(brother.getY() < node.getY()) || !(node.getX() < brother.getX() && brother.getX() < this.getNode(node.getLink(this.getCurrentLevel())).getX()) && (!(node.getX() > brother.getX()) || !(brother.getX() > this.getNode(node.getLink(this.getCurrentLevel())).getX()))) continue;
                    node.setY(brother.getY());
                }
            }
        }
    }

    private void drawNodes() {
        this._SVGGen.setPaint((Paint)Color.black);
        this.doZoom();
        this.setBelowTreeY(this.getMaxY() + (double)this._font.getSize() + 3.0);
        this.resetNonCurrentYs();
        this.setBeforeStroke(this._SVGGen.getStroke());
        for (DepTreeNode node : this) {
            this.drawVerticalLine(node);
        }
        if (this.getBoxType() == BoxType.COMPLEX) {
            for (DepTreeNode node : this) {
                this.drawSYNLabel(node);
            }
        }
        for (DepTreeNode node : this) {
            if (node.linkIsRoot(this.getCurrentLevel())) {
                this.drawRoot(node);
                continue;
            }
            this.drawCurrentLine(node);
        }
        for (DepTreeNode node : this) {
            this.drawDot(node, true);
            this.drawWord(node, true);
            this.drawCatAndReferent(node, true);
        }
        for (DepTreeNode node : this) {
            this.drawNoncurrentLine(node, true);
        }
        this.resetNonCurrentYs();
        for (DepTreeNode node : this) {
            this.drawCurrentLineInvisible(node);
            this.drawNoncurrentLine(node, false);
            this.drawWord(node, false);
        }
        if (this.getBoxType() == BoxType.SIMPLE) {
            for (DepTreeNode node : this) {
                this.drawSYNLabel(node);
            }
        }
        for (DepTreeNode node : this) {
            this.drawDot(node, false);
        }
        this.setCanvasSizeY((int)(this.getBelowTreeY() + 12.0 + (double)(this._font.getSize() * 2)));
        this.setCanvasSize(new Dimension(this.getCanvasSizeX(), this.getCanvasSizeY()));
        this._SVGGen.setSVGCanvasSize(this.getCanvasSize());
        this.getNodesCanvas().setDocumentState(1);
        this.getNodesCanvas().setEnableRotateInteractor(false);
        this.getNodesCanvas().setEnableZoomInteractor(false);
        this.getNodesCanvas().setEnablePanInteractor(false);
        this.getNodesCanvas().setEnableImageZoomInteractor(false);
        this.getNodesCanvas().setEnableResetTransformInteractor(false);
        this.passContent();
        this.highlightNodes();
    }

    private void passContent() {
        Element root = this.getDoc().getDocumentElement();
        this._SVGGen.getRoot(root);
    }

    public void highlightNodes() {
        for (DepTreeNode node : this) {
            this.highlight(node);
        }
    }

    public void highlight(DepTreeNode node) {
        for (String level : this.getLevels()) {
            this.changeColor(node.getColoringGroup(level), Color.black);
        }
        if (!node.linkIsRoot(this.getCurrentLevel()) && node.getY() <= this.getNode(node.getLink(this.getCurrentLevel())).getY()) {
            this.changeColor(node.getColoringGroup(this.getCurrentLevel()), darkRed);
        }
        if (node.getMarkedLevels() != null) {
            for (String level : node.getMarkedLevels()) {
                if (!level.equals(this.getCurrentLevel()) && node.linkIsRoot(level)) continue;
                this.changeColor(node.getColoringGroup(level), this.getHighlightColor());
            }
        }
    }

    public void changeColor(ArrayList<Element> nodeElements, Color color) {
        if (nodeElements != null) {
            for (Element e : nodeElements) {
                Element g = (Element)e.getParentNode();
                g.setAttribute("stroke", "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
                g.setAttribute("stroke-opacity", "" + (float)color.getAlpha() / 255.0f);
                g.setAttribute("fill", "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
                g.setAttribute("fill-opacity", "" + (float)color.getAlpha() / 255.0f);
            }
        }
    }

    public void writeTree(Writer writer) throws SVGGraphics2DIOException {
        this.redraw();
        Element root = this.getDoc().getDocumentElement();
        root.setAttributeNS(null, "viewBox", "0 0 " + this._SVGGen.getSVGCanvasSize().getWidth() + " " + this._SVGGen.getSVGCanvasSize().getHeight());
        this._SVGGen.stream(this.getDoc().getDocumentElement(), writer);
    }

    public static void writeTree(List<String> levels, Map<String, List<String>> verticesLabels, Map<String, List<Integer>> verticesStructure, List<String> words, Writer w) {
        DepTree.writeTree(levels, verticesLabels, verticesStructure, words, null, w);
    }

    public static void writeTree(List<String> levels, Map<String, List<String>> verticesLabels, Map<String, List<Integer>> verticesStructure, List<String> words, Map<Integer, ArrayList<String>> markedNodes, Writer w) {
        DepTree dt = new DepTree(markedNodes);
        dt.setShowingCat(false);
        super.setFields(levels, verticesLabels, verticesStructure);
        super.initGraph();
        super.generateWordNodes(words);
        super.initWordNodes();
        super.setYPositions(dt._forestTODO, dt._nodesTODO);
        super.buildCircles();
        super.dropLeaves();
        super.drawNodes();
        super.passContent();
        try {
            Element root = dt.getDoc().getDocumentElement();
            root.setAttributeNS(null, "viewBox", "0 0 " + dt._SVGGen.getSVGCanvasSize().getWidth() + " " + dt._SVGGen.getSVGCanvasSize().getHeight());
            dt._SVGGen.stream(dt.getDoc().getDocumentElement(), w);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawCurrentLineInvisible(DepTreeNode node) {
        this._SVGGen.setPaint((Paint)invisible);
        this._SVGGen.setStroke(this.getSelectStroke());
        if (node.linkIsRoot(this.getCurrentLevel())) {
            Line2D.Double line = new Line2D.Double((int)node.getX(), 0.0, (int)node.getX(), (int)node.getY());
            this.drawShape(node, line, Elem.HIDDENLINE, this.getCurrentLevel(), null, false, false);
        } else {
            double linkX = this.getNode(node.getLink(this.getCurrentLevel())).getX();
            double linkY = this.getNode(node.getLink(this.getCurrentLevel())).getY();
            if (node.getY() > linkY) {
                Line2D.Double line = new Line2D.Double(node.getX(), node.getY(), linkX, linkY);
                this.drawShape(node, line, Elem.HIDDENLINE, this.getCurrentLevel(), null, false, false);
            } else {
                double sign = node.getX() < linkX ? 1.0 : -1.0;
                CubicCurve2D.Double curve = new CubicCurve2D.Double(node.getX(), node.getY(), (node.getX() + linkX) * 2.0 / 4.0 - this.getCurrentYLength() * sign, (node.getY() + linkY) / 4.0 - this.getCurrentYLength() / 2.0, (node.getX() + linkX) * 2.0 / 4.0 + this.getCurrentYLength() * sign, (node.getY() + linkY) / 4.0 - this.getCurrentYLength() / 2.0, linkX, linkY);
                this.drawShape(node, curve, Elem.HIDDENLINE, this.getCurrentLevel(), null, false, false);
            }
            this._SVGGen.setStroke(this.getBeforeStroke());
        }
    }

    private void drawWord(DepTreeNode node, boolean isVisible) {
        Rectangle2D wordBorder = this._font.getStringBounds(node.getWord(), this._SVGGen.getFontRenderContext());
        if (isVisible) {
            this._SVGGen.setPaint((Paint)Color.black);
            this.drawString(node.getWord(), node.getX(), (int)this.getMaxY() + this._font.getSize() + 3, node, "DEPTREEWORD", 0.0);
        } else {
            this._SVGGen.setPaint((Paint)invisible);
            double x = wordBorder.getMaxX() + 2.0;
            double y = this._font.getSize() + 1;
            if (this.isShowingCat()) {
                x = Math.max(x, this._font.getStringBounds(this.getCat(node), this._SVGGen.getFontRenderContext()).getMaxX());
                y = this._font.getSize() * 2 + 4;
            }
            if (this.isShowingReferent()) {
                x = Math.max(x, this._font.getStringBounds(this.getReferent(node), this._SVGGen.getFontRenderContext()).getMaxX());
                y = this._font.getSize() * 2 + 4;
            }
            wordBorder.setRect(node.getX() - 1.0 - wordBorder.getWidth() / 2.0, this.getMaxY() + 5.0, x, y);
            this._SVGGen.fill((Shape)wordBorder);
            this.passContent();
            node.setElement(this.getCurrentElement(), Elem.HIDDENBOX, "DEPTREEWORD");
        }
    }

    private void drawCatAndReferent(DepTreeNode node, boolean isVisible) {
        if (isVisible) {
            int adjustment = 0;
            if (this.isShowingCat()) {
                this.drawString(this.getCat(node), node.getX(), this.getBelowTreeY() + (double)this._font.getSize() + 3.0, node, "DEPTREEWORD", 0.0);
                ++adjustment;
            }
            if (this.isShowingReferent()) {
                this.drawString(this.getReferent(node), node.getX(), this.getBelowTreeY() + (double)(this._font.getSize() * (1 + adjustment)) + 3.0 + (double)adjustment, node, "DEPTREEWORD", 0.0);
            }
        }
    }

    private void drawVerticalLine(DepTreeNode node) {
        Line2D.Double greyLine = new Line2D.Double(node.getX(), node.getY(), node.getX(), this.getMaxY());
        this._SVGGen.setStroke(this.getLineStroke());
        this._SVGGen.setPaint((Paint)Color.lightGray);
        this.drawShape(node, greyLine, null, null, null, true, false);
        this._SVGGen.setStroke(this.getBeforeStroke());
        this.passContent();
    }

    private void drawRoot(DepTreeNode node) {
        if (this.isDrawingRoots()) {
            this._SVGGen.setPaint((Paint)Color.black);
            this._SVGGen.setStroke(this.getLineStroke());
            Line2D.Double line = new Line2D.Double(node.getX(), node.getY(), node.getX(), this.getMinY());
            double size = this.getLineThickness() + 5;
            double rad = size / 2.0;
            Ellipse2D.Double topPoint = new Ellipse2D.Double(node.getX() - rad, this.getMinY() - rad, size, size);
            String level = this.getCurrentLevel();
            this.drawShape(node, topPoint, null, null, level, true, true);
            this.drawShape(node, line, Elem.LINE, level, level, true, false);
            String text = "[]";
            if (!"".equals(node.getLabel(level))) {
                text = node.getLabel(level);
            }
            this.drawString(text, node.getX() + (double)this._font.getSize(), (node.getY() - (double)this._font.getSize()) / 2.0 + this.getMinY(), node, level, 0.0);
            this._SVGGen.setPaint((Paint)Color.black);
        }
    }

    private void drawTransparentSimpleBox(Rectangle2D wordBorder) {
        if (this.isDrawingBoxes() && this.getBoxType() == BoxType.SIMPLE) {
            this._SVGGen.setPaint((Paint)this.getTransparentColor());
            this._SVGGen.fill((Shape)wordBorder);
            this._SVGGen.setPaint((Paint)Color.black);
            this.passContent();
        }
    }

    private void drawTransparentComplexBox(double x, double y, Rectangle2D wordBorder, double rotation) {
        if (this.isDrawingBoxes() && this.getBoxType() == BoxType.COMPLEX) {
            wordBorder.setFrame((int)x, (double)((int)y) - wordBorder.getHeight() + 4.0, wordBorder.getWidth(), wordBorder.getHeight());
            AffineTransform t = this._SVGGen.getTransform();
            Path2D.Double box = new Path2D.Double(wordBorder);
            box.transform(t);
            this.getTransparentBoxes().append(box, false);
        }
    }

    private void drawString(String text, double xCenter, double y, DepTreeNode node, String level, double rotation) {
        Rectangle2D wordBorder = this.getWordBorder(text, xCenter, y);
        double x = xCenter - wordBorder.getWidth() / 2.0;
        this.drawTransparentSimpleBox(wordBorder);
        this._SVGGen.setStroke(this.getBeforeStroke());
        this._SVGGen.drawString(text, (int)x, (int)y);
        this.passContent();
        if (level != null) {
            node.setElement(this.getCurrentElement(), Elem.TEXT, level);
            node.addToColoringGroup(this.getCurrentElement(), level);
        }
        this.drawTransparentComplexBox(x, y, wordBorder, rotation);
    }

    private Rectangle2D getWordBorder(String text, double xCenter, double y) {
        Rectangle2D wordBorder = this._font.getStringBounds(text, this._SVGGen.getFontRenderContext());
        double x = xCenter - wordBorder.getCenterX();
        wordBorder.setFrame((int)x, (double)((int)y) - wordBorder.getHeight() + 4.0, wordBorder.getWidth(), wordBorder.getHeight());
        return wordBorder;
    }

    private void drawShape(DepTreeNode node, Shape s, Elem elemType, String elemLevel, String groupLevel, boolean isVisible, boolean isFilling) {
        this.drawOrFillShape(s, isFilling);
        this.passContent();
        Element element = this.getCurrentElement();
        if (elemLevel != null && elemType != null) {
            node.setElement(element, elemType, elemLevel);
        }
        if (groupLevel != null) {
            node.addToColoringGroup(element, groupLevel);
        }
        if (this.getBoxType() == BoxType.COMPLEX && isVisible) {
            Shape beforeClip = this._SVGGen.getClip();
            Path2D.Double boxes = this.getTransparentBoxes();
            this._SVGGen.clip((Shape)boxes);
            this._SVGGen.setColor(this.getTransparentColor());
            this.drawOrFillShape(s, isFilling);
            this._SVGGen.setColor(Color.black);
            this._SVGGen.setClip(beforeClip);
        }
    }

    private void drawOrFillShape(Shape s, boolean isFilling) {
        if (isFilling) {
            this._SVGGen.fill(s);
        } else {
            this._SVGGen.draw(s);
        }
    }

    private void drawCurrentLine(DepTreeNode node) {
        this._SVGGen.setPaint((Paint)Color.black);
        this._SVGGen.setStroke(this.getLineStroke());
        double linkX = this.getNode(node.getLink(this.getCurrentLevel())).getX();
        double linkY = this.getNode(node.getLink(this.getCurrentLevel())).getY();
        if (node.getY() > linkY) {
            Line2D.Double line = new Line2D.Double(node.getX(), node.getY(), linkX, linkY);
            String level = this.getCurrentLevel();
            this.drawShape(node, line, Elem.LINE, level, level, true, false);
            this._SVGGen.setStroke(this.getBeforeStroke());
        } else {
            double sign = node.getX() < linkX ? 1.0 : -1.0;
            CubicCurve2D.Double curve = new CubicCurve2D.Double(linkX, linkY, (node.getX() + linkX) * 2.0 / 4.0 + this.getCurrentYLength() * sign, (node.getY() + linkY) / 4.0 - this.getCurrentYLength() / 2.0, (node.getX() + linkX) * 2.0 / 4.0 - this.getCurrentYLength() * sign, (node.getY() + linkY) / 4.0 - this.getCurrentYLength() / 2.0, node.getX(), node.getY());
            this._SVGGen.setPaint((Paint)darkRed);
            String level = this.getCurrentLevel();
            this.drawShape(node, curve, Elem.LINE, level, level, true, false);
            this._SVGGen.setStroke(this.getBeforeStroke());
        }
        this._SVGGen.setPaint((Paint)Color.black);
    }

    private void drawNoncurrentLine(DepTreeNode node, boolean isVisible) {
        for (String level : this.getLevels()) {
            Rectangle2D wordBorder;
            double cy;
            double cx;
            Line2D.Double line2;
            Line2D.Double line1;
            Path2D.Double curve;
            if (!this.getCurrentLevel().equals("SYN") || level.equals(this.getCurrentLevel()) || level.startsWith("DEPTREE") || node.linkIsRoot(level)) continue;
            String label = level;
            if (!node.getLabel(level).equals("")) {
                label = label + " : " + node.getLabel(level);
            }
            int arrowHeadWidth = 1 + this.getLineThickness();
            double refX = this.getNode(node.getLink(level)).getX();
            double y = this.getMaxY() + (double)(this._font.getSize() * 2);
            if (this.isShowingCat()) {
                y += (double)this._font.getSize();
            }
            if (this.isShowingReferent()) {
                y += (double)this._font.getSize();
            }
            do {
                this.setNonCurrentLevel(node, level);
                if (this.getNonCurrentYs().size() == 0) {
                    this.addNonCurrentY(y);
                }
                double endY = this.getNonCurrentYs().get(node.getNonCurrentYLevel(level) - 1);
                int diff = (int)this.getREFYLength() / 2;
                refX = refX < node.getX() ? (refX += (double)arrowHeadWidth) : (refX -= (double)arrowHeadWidth);
                curve = new Path2D.Double();
                curve.moveTo(refX, endY);
                curve.lineTo(refX, endY + (double)arrowHeadWidth);
                curve.curveTo(refX, endY + (double)diff, node.getX(), endY + (double)diff, node.getX(), endY + (double)arrowHeadWidth);
                curve.lineTo(node.getX(), endY);
                line1 = new Line2D.Double(refX, endY - (double)this.getLineThickness(), refX - (double)arrowHeadWidth, endY + 1.0);
                line2 = new Line2D.Double(refX, endY - (double)this.getLineThickness(), refX + (double)arrowHeadWidth, endY + 1.0);
                Area area = new Area(curve);
                cx = curve.getBounds2D().getCenterX();
                cy = area.getBounds().getMaxY();
                wordBorder = this.getWordBorder(label, cx, cy);
                node.setNonCurrentLabelBorder(wordBorder, level);
                for (DepTreeNode node2 : this) {
                    for (String level2 : this.getLevels()) {
                        Rectangle2D labelBorder = node.getNonCurrentLabelBorder(level);
                        Rectangle2D labelBorder2 = node2.getNonCurrentLabelBorder(level2);
                        if (labelBorder == null || labelBorder2 == null || node2 == node && level.equals(level2) || level2.equals(this.getCurrentLevel()) || !labelBorder.intersects(labelBorder2)) continue;
                        this.setOverlapping(true);
                    }
                }
            } while (this.isOverlapping());
            if (isVisible) {
                this._SVGGen.setPaint((Paint)Color.black);
                this._SVGGen.setStroke(this.getLineStroke());
                this.drawShape(node, line1, Elem.ARROWLINE1, level, level, true, false);
                this.drawShape(node, line2, Elem.ARROWLINE2, level, level, true, false);
                this.drawShape(node, curve, Elem.LINE, level, level, true, false);
                this.drawString(label, cx, cy + (double)this._font.getSize(), node, level, 0.0);
            } else {
                this._SVGGen.setPaint((Paint)invisible);
                this._SVGGen.setStroke(this.getSelectStroke());
                this.drawShape(node, line1, Elem.HIDDENLINE, level, null, false, false);
                this.drawShape(node, line2, Elem.HIDDENLINE, level, null, false, false);
                this.drawShape(node, curve, Elem.HIDDENLINE, level, null, false, false);
            }
            this._SVGGen.setPaint((Paint)Color.BLACK);
            this.addNonCurrentY(cy + (double)this._font.getSize() + (double)this.getLineThickness() + 2.0);
            this.setBelowTreeY(this.getNonCurrentYs().get(this.getNonCurrentYs().size() - 1) - wordBorder.getHeight());
        }
    }

    private void setNonCurrentLevel(DepTreeNode node1, String level1) {
        boolean NonCurLineFits;
        int maxNonCurLevel = 0;
        this.setOverlapping(false);
        do {
            NonCurLineFits = true;
            node1.setNonCurrentYLevel(node1.getNonCurrentYLevel(level1) + 1, level1);
            for (DepTreeNode node2 : this) {
                for (String level2 : this.getLevels()) {
                    if (node2 == node1 && level1.equals(level2) || level2.equals(this.getCurrentLevel())) continue;
                    maxNonCurLevel = Math.max(maxNonCurLevel, node2.getNonCurrentYLevel(level2));
                    if (node2.getNonCurrentYLevel(level2) != node1.getNonCurrentYLevel(level1) || node2.linkIsRoot(level2) || !this.IntervalsOverlap(node1.getIndex(), node1.getLink(level1), node2.getIndex(), node2.getLink(level2))) continue;
                    NonCurLineFits = false;
                }
            }
        } while (!NonCurLineFits && node1.getNonCurrentYLevel(level1) <= maxNonCurLevel);
    }

    private boolean IntervalsOverlap(int a, int b, int x, int y) {
        return Math.max(a, b) > Math.min(x, y) && Math.min(a, b) < Math.max(x, y);
    }

    private void drawSYNLabel(DepTreeNode node) {
        String level = this.getCurrentLevel();
        if (!node.linkIsRoot(level)) {
            double linkX = this.getNode(node.getLink(level)).getX();
            double linkY = this.getNode(node.getLink(level)).getY();
            String text = "[]";
            if (!"".equals(node.getLabel(level))) {
                text = node.getLabel(level);
            }
            if (node.getY() > linkY) {
                float incline = (float)(linkX - node.getX()) / (float)(node.getY() - linkY);
                float x = (float)(linkX + (node.getX() - linkX) / 2.0);
                float y = (float)(linkY + (node.getY() - linkY) / 2.0);
                float rotation = node.getX() > linkX ? (float)(Math.atan(incline) + 1.5707963267948966) : (float)(Math.atan(Math.abs(incline)) - 1.5707963267948966);
                this._SVGGen.rotate((double)rotation, (double)x, (double)y);
                this._SVGGen.setPaint((Paint)this.getTransparentColor());
                this.drawString(text, x, y - (float)this.getLineThickness() - 2.0f, node, level, rotation);
                this._SVGGen.rotate((double)(-rotation), (double)x, (double)y);
            } else {
                float incline = node.getY() != linkY ? (float)(linkX - node.getX()) / (float)(node.getY() - linkY) : 0.0f;
                float rotation = node.getX() < linkX ? (float)(Math.atan(incline) + 1.5707963267948966) : (float)(Math.atan(Math.abs(incline)) - 1.5707963267948966);
                float x = (float)(node.getX() + linkX) * 2.0f / 4.0f - (float)this._font.getSize() * (incline + 1.0f) / 2.0f;
                float y = (float)(node.getY() + linkY) / 4.0f;
                this._SVGGen.rotate((double)rotation, (double)x, (double)y);
                this.drawString(text, x, y - (float)this._font.getSize(), node, level, rotation);
                this._SVGGen.rotate((double)(-rotation), (double)x, (double)y);
                this._SVGGen.setPaint((Paint)Color.black);
            }
            this._SVGGen.setPaint((Paint)Color.black);
        }
    }

    private void drawDot(DepTreeNode node, boolean isVisible) {
        double size = this.getLineThickness() + 5;
        Color color = Color.black;
        if (!isVisible) {
            size = this.getSelectThickness() + 5;
            color = invisible;
        }
        double rad = size / 2.0;
        Ellipse2D.Double point = new Ellipse2D.Double(node.getX() - rad, node.getY() - rad, size, size);
        this._SVGGen.setPaint((Paint)color);
        this.drawShape(node, point, isVisible ? Elem.DOT : Elem.HIDDENDOT, this.getCurrentLevel(), isVisible ? "DEPTREEWORD" : null, isVisible, true);
    }

    private class CommandID {
        DepTreeBaseInteractor.Com _type;
        DepTreeNode _node;
        String _level;
        boolean _isTarget;

        CommandID(DepTreeBaseInteractor.Com type, DepTreeNode node, String level, boolean isTarget) {
            this._type = type;
            this._node = node;
            this._level = level;
            this._isTarget = isTarget;
        }

        public boolean equals(Object o) {
            if (o.getClass() == CommandID.class) {
                CommandID id = (CommandID)o;
                return this.equals(id);
            }
            return false;
        }

        public boolean equals(CommandID id) {
            if (this._node == null) {
                return this._type.equals((Object)id._type) && id._node == null && this._level.equals(id._level) && this._isTarget == id._isTarget;
            }
            return this._type.equals((Object)id._type) && this._node.equals(id._node) && this._level.equals(id._level) && this._isTarget == id._isTarget;
        }

        public int hashCode() {
            int i = 0;
            if (this._isTarget) {
                i = 1;
            }
            int nodecode = 0;
            if (this._node != null) {
                nodecode = this._node.hashCode();
            }
            return this._type.hashCode() + nodecode + this._level.hashCode() + i;
        }
    }

    public static enum Elem {
        LINE,
        TEXT,
        DOT,
        HIDDENLINE,
        HIDDENBOX,
        HIDDENDOT,
        ARROWLINE1,
        ARROWLINE2;

    }

    private static enum BoxType {
        SIMPLE,
        COMPLEX;

    }
}

