/*
 * Copyright  2017  Natural Language Systems Group, Uni Hamburg
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package io.gitlab.nats.deptreeviz;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

/**
 * Example class that converts Conll to SVG
 * @author Arne Köhn
 */
class ConllToSVG {
	public static void main(String[] args) throws IOException {
		List<String> conll = Files.readAllLines(Paths.get(args[0]));
		SimpleParse p = SimpleParse.fromConll(conll);
		DepTree<SimpleParse, SimpleWord> dt = new DepTree<>(p);
		// write tree
		StringWriter w = new StringWriter();
		dt.writeTree(w);
		System.out.println(w.toString());
	}
}
