/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.annotate.ResourceManager;
import com.litehost.annotate.ResourcePath;
import com.litehost.core.ClientRequest;
import com.litehost.core.ExceptionHandlers;
import com.litehost.core.IncomingRequest;
import com.litehost.core.NoDefaultConstructorException;
import com.litehost.core.NotResponseException;
import com.litehost.core.Response;
import com.litehost.core.Server;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.atteo.classindex.ClassIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Wrapper
extends Thread {
    private BlockingQueue<Socket> connections;
    private BlockingQueue<ClientRequest> tasks;
    Map<String, Method> requestMappings = null;
    private int maxThreads;
    private Logger logger;

    Wrapper(BlockingQueue<Socket> connections, BlockingQueue<ClientRequest> tasks, int maxExecutingThreads) {
        this.connections = connections;
        this.tasks = tasks;
        this.maxThreads = maxExecutingThreads;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private void initializeMappings() {
        StringBuilder result = new StringBuilder();
        Response responseCheck = Response.builder().build();
        IncomingRequest requestCheck = new IncomingRequest();
        Iterable classes = ClassIndex.getAnnotated(ResourceManager.class);
        classes.forEach(clazz -> {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new NoDefaultConstructorException("Manager class must have default constructor!");
            }
        });
        ConcurrentHashMap<String, Method> mapping = new ConcurrentHashMap<String, Method>(10, 0.75f, this.maxThreads);
        for (Class clazz2 : classes) {
            Method[] methods;
            for (Method method : methods = clazz2.getMethods()) {
                ResourcePath annotation = method.getAnnotation(ResourcePath.class);
                if (annotation == null) continue;
                Parameter[] parameters = method.getParameters();
                if (parameters.length > 0) {
                    if (parameters.length != 1) {
                        throw new IllegalArgumentException("Only one Request parameter, or no parameters can be passed!");
                    }
                    if (!parameters[0].getType().isInstance(requestCheck)) {
                        throw new IllegalArgumentException("Parameter must be a Request!");
                    }
                }
                String resourcePath = annotation.path();
                String httpMethod = annotation.method();
                result.append(httpMethod);
                result.append(resourcePath);
                if (!method.getReturnType().isInstance(responseCheck)) {
                    throw new NotResponseException("Handling method return type must be a Response!");
                }
                String signature = result.toString();
                if (signature.contains("{")) {
                    signature = signature.replaceAll("\\{\\w+}", "\\\\w+");
                }
                mapping.put(signature, method);
                result = new StringBuilder();
            }
        }
        this.requestMappings = mapping;
        ClientRequest.requestMappings = this.requestMappings;
        System.gc();
    }

    private ClientRequest wrap(Socket connection) {
        ClientRequest clientRequest = null;
        try {
            clientRequest = new ClientRequest(connection);
            clientRequest.readRequest();
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage());
        }
        return clientRequest;
    }

    @Override
    public synchronized void start() {
        this.setUncaughtExceptionHandler(ExceptionHandlers.stopHandler());
        this.setDaemon(true);
        try {
            this.initializeMappings();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println(" === Startup aborted ===\n");
            System.exit(420);
        }
        super.start();
        System.out.println(" === Resource managers mapped ===\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShutdownProcedure() {
        try {
            while (!this.connections.isEmpty()) {
                this.tasks.put(this.wrap((Socket)this.connections.poll()));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = Server.shutdownLock;
        synchronized (object) {
            Server.shutdownLock.notify();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (Wrapper.interrupted()) {
                    this.runShutdownProcedure();
                    break;
                }
                Socket connection = this.connections.take();
                this.tasks.put(this.wrap(connection));
            }
        }
        catch (InterruptedException e) {
            this.runShutdownProcedure();
        }
    }
}

