/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.core.ClientRequest;
import com.litehost.core.ExceptionHandlers;
import com.litehost.core.Listener;
import com.litehost.core.Respondent;
import com.litehost.core.Wrapper;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Server
extends Thread {
    Listener listener;
    Wrapper wrapper;
    Respondent respondent;
    BlockingQueue<ClientRequest> tasks;
    BlockingQueue<Socket> connections;
    BlockingQueue<Future<ClientRequest>> finishedTasks;
    private ExecutorService scheduler;
    private static int maxThreadPool;
    final String domainName;
    static final Object shutdownLock;
    final int port;

    Server(int port, int minThreadPool, int maxThreadPool, String domainName) {
        ExceptionHandlers.initialize(this);
        Server.maxThreadPool = maxThreadPool;
        this.port = port;
        this.domainName = domainName;
        this.connections = new LinkedBlockingQueue<Socket>();
        this.tasks = new LinkedBlockingQueue<ClientRequest>();
        this.finishedTasks = new LinkedBlockingQueue<Future<ClientRequest>>();
        this.scheduler = new ThreadPoolExecutor(minThreadPool, maxThreadPool, 5L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setUncaughtExceptionHandler(ExceptionHandlers.stopHandler());
            return thread;
        });
        this.wrapper = new Wrapper(this.connections, this.tasks, maxThreadPool);
        this.listener = new Listener(this.port, this.connections, domainName);
        this.respondent = new Respondent(this.finishedTasks);
    }

    static int getMaxThreadPool() {
        return maxThreadPool;
    }

    @Override
    public void start() {
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(ExceptionHandlers.stopHandler());
        long zeroTime = System.nanoTime();
        System.out.println(" Server staring up...");
        this.listener.start();
        this.wrapper.start();
        this.respondent.start();
        super.start();
        System.out.println(" Finished starting up, elapsed time: " + (System.nanoTime() - zeroTime) / 1000000L + "ms");
        System.out.println(" Listening on port " + this.listener.getPort());
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info(" Server successfully started");
    }

    public void stopServer() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShutdownProcedure() {
        this.wrapper.interrupt();
        try {
            Object object = shutdownLock;
            synchronized (object) {
                shutdownLock.wait();
            }
            while (!this.tasks.isEmpty()) {
                this.finishedTasks.put(this.scheduler.submit((Callable)this.tasks.poll()));
            }
            object = shutdownLock;
            synchronized (object) {
                shutdownLock.notify();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.respondent.interrupt();
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (Server.interrupted()) {
                    this.runShutdownProcedure();
                    return;
                }
                ClientRequest clientRequest = this.tasks.take();
                Future<ClientRequest> runningTask = this.scheduler.submit(clientRequest);
                this.finishedTasks.put(runningTask);
            }
        }
        catch (InterruptedException e) {
            this.runShutdownProcedure();
            return;
        }
    }

    static {
        shutdownLock = new Object();
    }
}

