/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

class Requests {
    private Requests() {
    }

    public static String getMethod(String request) {
        return request.substring(0, request.indexOf(" "));
    }

    public static Map<String, String> getHeaders(String request) {
        HashMap<String, String> result = new HashMap<String, String>();
        int blankLineIndex = Requests.getBlankLineIndex(request);
        if (blankLineIndex == request.length()) {
            return null;
        }
        request.substring(0, blankLineIndex).lines().filter(line -> !line.contains("ookie")).skip(1L).forEach(line -> {
            int separator = line.indexOf(58);
            result.put(line.substring(0, separator).toLowerCase(), line.substring(separator + 1));
        });
        return result;
    }

    private static Stream<String> cookieStream(String request) {
        return request.substring(0, Requests.getBlankLineIndex(request)).lines().filter(line -> line.contains("ookie")).map(line -> line.substring(line.indexOf(":") + 2));
    }

    public static List<String> getCookies(String request) {
        ArrayList<String> cookies = new ArrayList<String>();
        Requests.cookieStream(request).forEach(line -> {
            String[] values = line.split(";");
            cookies.addAll(Arrays.asList(values));
        });
        return cookies;
    }

    public static Map<String, String> cookieMap(String request) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        Requests.cookieStream(request).map(line -> line.split(";")).forEach(pairs -> {
            for (String pair : pairs) {
                String[] data = pair.split("=");
                cookieMap.put(data[0], data[1]);
            }
        });
        return cookieMap;
    }

    public static String getStatus(String response) {
        if (response.indexOf(10) == -1) {
            return response;
        }
        return response.substring(response.indexOf(32) + 1, response.indexOf(10));
    }

    public static String getVersion(String response) {
        return response.substring(0, response.indexOf(32));
    }

    public static Map<String, String> getHeaders(byte[] bytes) {
        String request = new String(bytes);
        return Requests.getHeaders(request);
    }

    public static String getBody(String request) {
        int blankLineIndex = Requests.getBlankLineIndex(request);
        if (blankLineIndex == request.length()) {
            return null;
        }
        return request.substring(blankLineIndex + 2);
    }

    public static String getBody(String request, int blankLineIndex) {
        int fromLine = blankLineIndex + 2;
        if (fromLine >= request.length()) {
            return null;
        }
        return request.substring(fromLine);
    }

    public static String getMethodAndPath(String request) {
        return Requests.getMethod(request) + Requests.getResourcePath(request);
    }

    public static String getResourcePath(String request) {
        int firstSpace = request.indexOf(" ") + 1;
        return request.substring(firstSpace, request.indexOf(" ", firstSpace + 1));
    }

    public static int getBlankLineIndex(String request) {
        int index = request.indexOf("\n\n");
        if (index == -1) {
            index = request.indexOf("\r\n\r\n");
        }
        if (index == -1) {
            index = request.length();
        }
        return index;
    }
}

