/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class Request {
    private String method = null;
    private String version = "HTTP/1.1";
    private String path = null;
    private String url = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private String body = null;
    private boolean mutable = false;

    Request() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean change(String fieldName, Object value) {
        if (!this.mutable) {
            return false;
        }
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            Class<?> fieldClass = field.getType();
            if (!fieldClass.isInstance(value)) {
                throw new IllegalArgumentException("Incompatible types!");
            }
            field.setAccessible(true);
            field.set(this, value);
            field.setAccessible(false);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.method).append(' ').append(this.path).append(' ').append(this.version).append('\n');
        if (this.headers != null) {
            this.headers.forEach((key, value) -> result.append((String)key).append(": ").append((String)value).append('\n'));
        }
        result.append('\n');
        if (this.body != null) {
            result.append(this.body);
        }
        return result.toString();
    }

    public static class Builder {
        private Request rawRequest = new Request();

        Builder() {
        }

        public Builder mutable(boolean mutable) {
            this.rawRequest.mutable = mutable;
            return this;
        }

        public Builder version(String version) {
            this.rawRequest.version = version;
            return this;
        }

        public Builder URL(String url) {
            int start = url.indexOf(47) + 2;
            int end = url.indexOf(47, start);
            this.rawRequest.url = url;
            this.rawRequest.path = url.substring(end);
            this.rawRequest.headers.put("Host", url.substring(start, end));
            return this;
        }

        public Builder GET() {
            this.rawRequest.method = "GET";
            return this;
        }

        public Builder POST() {
            this.rawRequest.method = "POST";
            return this;
        }

        public Builder PUT() {
            this.rawRequest.method = "PUT";
            return this;
        }

        public Builder DELETE() {
            this.rawRequest.method = "DELETE";
            return this;
        }

        public Builder header(final String header, final String value) {
            if (this.rawRequest.headers != null) {
                this.rawRequest.headers.put(header, value);
            } else {
                this.rawRequest.headers = new HashMap<String, String>(){
                    {
                        this.put(header, value);
                    }
                };
            }
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.rawRequest.headers = headers;
            String connectionHeader = headers.get("Connection");
            if (connectionHeader == null) {
                this.rawRequest.headers.put("Connection", "Close");
            }
            return this;
        }

        public Builder body(String body) {
            this.rawRequest.body = body;
            return this;
        }

        public Request build() {
            return this.rawRequest;
        }
    }
}

