/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.core.ExceptionHandlers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Listener
extends Thread {
    ServerSocket socket;
    private BlockingQueue<Socket> requestQueue;
    private int port;
    private Logger logger;
    boolean running;

    public Listener(int socket, BlockingQueue<Socket> acceptedRequestQueue, String domainName) {
        this.port = socket;
        this.running = true;
        try {
            this.socket = new ServerSocket(socket, Integer.MAX_VALUE, InetAddress.getByName(domainName));
        }
        catch (IOException e) {
            this.logger.debug("Invalid address, cannot start LiteHost");
            System.exit(420);
        }
        this.requestQueue = acceptedRequestQueue;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public synchronized void start() {
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(ExceptionHandlers.stopHandler());
        super.start();
        System.out.println("\n=== Listener started ===\n");
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.requestQueue.put(this.socket.accept());
            }
            catch (IOException | InterruptedException e) {
                this.logger.debug(e.getMessage());
            }
        }
    }
}

