/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.core.Request;
import com.litehost.core.Response;
import com.litehost.core.Server;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostController {
    private static Server server = null;
    private static final Semaphore OUTPUT_PORT = new Semaphore(1, true);
    private static Logger logger = LoggerFactory.getLogger(HostController.class);

    private HostController() {
    }

    public static void startHost(int port) {
        try {
            HostController.startHost(port, InetAddress.getLocalHost().getHostAddress());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void startHost(int port, String domainName) {
        HostController.startHost(port, 5, domainName);
    }

    public static void startHost(int port, int maxPoolSize, String domainName) {
        HostController.startHost(port, 1, maxPoolSize, domainName);
    }

    public static void startHost(int port, int minPoolSize, int maxPoolSize, String domainName) {
        server = new Server(port, minPoolSize, maxPoolSize, domainName);
        server.start();
    }

    public static void stop() {
        server.stopServer();
    }

    public static Response sendRequest(String host, Request request) {
        return HostController.sendRequest(80, host, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response sendRequest(int port, String host, Request request) {
        String response;
        try {
            OUTPUT_PORT.acquire();
            Socket connection = new Socket(InetAddress.getByName(host), port);
            connection.getOutputStream().write(request.toString().getBytes());
            InputStream input = connection.getInputStream();
            int available = input.available();
            while (available == 0) {
                Thread.sleep(0L, 760000);
                available = input.available();
            }
            response = new String(input.readNBytes(input.available()));
            if (input.available() == 0) {
                connection.close();
            }
        }
        catch (IOException | InterruptedException e) {
            logger.debug(e.getMessage());
            Response response2 = null;
            return response2;
        }
        finally {
            OUTPUT_PORT.release();
        }
        return new Response(response);
    }
}

