/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.core.Listener;
import com.litehost.core.Respondent;
import com.litehost.core.Server;
import com.litehost.core.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlers {
    private static boolean initialized = false;
    private static Server server;

    private ExceptionHandlers() {
    }

    static void initialize(Server server) {
        if (!initialized) {
            ExceptionHandlers.server = server;
            initialized = true;
        }
    }

    static Thread.UncaughtExceptionHandler logHandler() {
        return new LogHandler();
    }

    static Thread.UncaughtExceptionHandler stopHandler() {
        return (t, e) -> {
            ExceptionHandlers.logHandler().uncaughtException(t, e);
            System.exit(420);
        };
    }

    static Thread.UncaughtExceptionHandler retryHandler(int maxRetry) {
        return new RetryHandler(maxRetry);
    }

    private static class LogHandler
    implements Thread.UncaughtExceptionHandler {
        private String additionalMessage = null;

        LogHandler() {
        }

        public void additionalMessage(String msg) {
            this.additionalMessage = msg;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            StringBuilder cause = new StringBuilder(e.getClass().getSimpleName());
            cause.append(' ');
            cause.append(e.getStackTrace()[0].toString());
            Logger logger = LoggerFactory.getLogger(Server.class);
            if (this.additionalMessage != null) {
                logger.debug("Exception " + cause.toString() + "at " + t.getName() + ", information: " + this.additionalMessage);
            } else {
                logger.debug("Exception " + cause.toString() + "at " + t.getName());
            }
        }
    }

    private static class RetryHandler
    implements Thread.UncaughtExceptionHandler {
        private int retryCounter;
        private int maxRetry;
        private LogHandler logHandler;

        RetryHandler(int maxRetry) {
            this.maxRetry = maxRetry;
            this.retryCounter = 0;
            this.logHandler = (LogHandler)ExceptionHandlers.logHandler();
        }

        private void registerRetry() {
            ++this.retryCounter;
        }

        private boolean validRetry() {
            this.registerRetry();
            return this.retryCounter <= this.maxRetry;
        }

        private Thread getNewThread(String threadName) {
            Thread newThread;
            switch (threadName) {
                case "Listener": {
                    ExceptionHandlers.server.listener = new Listener(ExceptionHandlers.server.port, ExceptionHandlers.server.connections, ExceptionHandlers.server.domainName);
                    newThread = ExceptionHandlers.server.listener;
                    break;
                }
                case "Respondent": {
                    newThread = ExceptionHandlers.server.respondent = new Respondent(ExceptionHandlers.server.finishedTasks);
                    break;
                }
                case "Wrapper": {
                    ExceptionHandlers.server.wrapper = new Wrapper(ExceptionHandlers.server.connections, ExceptionHandlers.server.tasks, Server.getMaxThreadPool());
                    newThread = ExceptionHandlers.server.wrapper;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + threadName);
                }
            }
            return newThread;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.validRetry()) {
                this.logHandler.uncaughtException(t, e);
                Thread newThread = this.getNewThread(t.getClass().getSimpleName());
                newThread.start();
            } else {
                this.logHandler.additionalMessage("Cannot retry anymore!");
                this.logHandler.uncaughtException(t, e);
            }
        }
    }
}

