/*
 * Decompiled with CFR 0.152.
 */
package com.litehost.core;

import com.litehost.core.HttpRequest;
import com.litehost.core.HttpStatus;
import com.litehost.core.IncomingRequest;
import com.litehost.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientRequest
implements Callable<ClientRequest>,
Closeable {
    private Socket connection;
    private HttpRequest httpRequest;
    static Map<String, Method> requestMappings;
    private byte[] receivedBytes;
    private Response response;
    private InputStream input;
    private OutputStream output;

    ClientRequest(Socket request) throws IOException {
        this.connection = request;
        this.input = this.connection.getInputStream();
        this.output = this.connection.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public void readRequest() throws IOException {
        int available;
        while ((available = this.input.available()) == 0) {
        }
        byte[] buffer = new byte[available];
        this.input.read(buffer, 0, available);
        this.receivedBytes = buffer;
    }

    public void sendResponse() throws IOException {
        this.output.write(this.response.toString().getBytes());
    }

    private Response invokeImplementedMethod() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        String handlingSignature = this.httpRequest.getHandlingSignature();
        Method handlingMethod = requestMappings.get(handlingSignature);
        ArrayList<String> variables = new ArrayList<String>();
        if (handlingMethod == null) {
            Optional<Map.Entry> optional = requestMappings.entrySet().stream().filter(entry -> {
                Pattern methodPattern = Pattern.compile((String)entry.getKey());
                Matcher matcher = methodPattern.matcher(handlingSignature);
                boolean found = matcher.find();
                if (found) {
                    Pattern pattern = Pattern.compile("\\w+");
                    Matcher m = pattern.matcher(handlingSignature);
                    while (m.find()) {
                        String variableValue = m.group();
                        if (((String)entry.getKey()).contains(variableValue)) continue;
                        variables.add(variableValue);
                    }
                }
                return found;
            }).findFirst();
            if (optional.isEmpty()) {
                return Response.builder().status(HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
            handlingMethod = (Method)optional.get().getValue();
        }
        Class<?> declaringClass = handlingMethod.getDeclaringClass();
        Parameter[] parameters = handlingMethod.getParameters();
        Constructor<?> defaultC = null;
        try {
            defaultC = declaringClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (parameters.length == 1) {
            return (Response)handlingMethod.invoke(defaultC.newInstance(new Object[0]), new IncomingRequest(this.httpRequest, variables));
        }
        return (Response)handlingMethod.invoke(defaultC.newInstance(new Object[0]), new Object[0]);
    }

    @Override
    public ClientRequest call() {
        try {
            this.httpRequest = new HttpRequest(new String(this.receivedBytes));
            this.response = this.invokeImplementedMethod();
            return this;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return this;
        }
    }
}

