package com.litehost.core;

import java.util.List;
import java.util.Map;

public class IncomingRequest {
    private HttpRequest request;
    private List<String> pathVariables = null;

    IncomingRequest(HttpRequest request) {
        this.request = request;
    }

    IncomingRequest() {
    }

    IncomingRequest(HttpRequest request, List<String> pathVariables) {
        this(request);
        this.pathVariables = pathVariables;
    }

    public Map<String, String> getHeaders() {
        return this.request.getHeaders();
    }

    public String pathVariable(int index) {
        if (pathVariables.size() - 1 >= index)
            return this.pathVariables.get(index);
        else return null;
    }

    public List<String> getPathVariables() {
        return this.pathVariables;
    }

    public String getBody() {
        return this.request.getBody();
    }

    public List<String> getCookies() {
        return this.request.getCookies();
    }

    public Map<String, String> cookieMap() {
        return this.request.cookieMap();
    }

}
