package com.litehost.core;

import java.util.List;
import java.util.Map;

class HttpRequest {
    private final String STRING_REPRESENTATION;
    private final int blankLineIndex;
    private boolean valid = true;

    public HttpRequest(String request) {
        if (request.length() == 0) {
            this.valid = false;
            throw new InvalidRequestException("Failed to read data from connection!");
        }
        this.STRING_REPRESENTATION = request;
        this.blankLineIndex = Requests.getBlankLineIndex(request);
    }

    public String getMethod() {
        if (this.valid)
            return Requests.getMethod(this.STRING_REPRESENTATION);
        else return null;
    }

    public String getHandlingSignature() {
        return Requests.getMethodAndPath(this.STRING_REPRESENTATION);
    }

    public Map<String, String> getHeaders() {
        return Requests.getHeaders(this.STRING_REPRESENTATION.getBytes());
    }

    public String getBody() {
        return Requests.getBody(this.STRING_REPRESENTATION, this.blankLineIndex);
    }

    public List<String> getCookies() {
        return Requests.getCookies(this.STRING_REPRESENTATION);
    }

    public Map<String, String> cookieMap() {
        return Requests.cookieMap(this.STRING_REPRESENTATION);
    }

    @Override
    public String toString() {
        return this.STRING_REPRESENTATION;
    }
}
