package com.litehost.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.Semaphore;

public class HostController {
    private static Server server = null;
    private static final Semaphore OUTPUT_PORT = new Semaphore(1, true);
    private static Logger logger = LoggerFactory.getLogger(HostController.class);

    private HostController() {
    }

    public static void startHost(int port) {
        try {
            startHost(port, InetAddress.getLocalHost().getHostAddress());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void startHost(int port, String domainName) {
        startHost(port, 5, domainName);
    }

    public static void startHost(int port, int maxPoolSize, String domainName) {
        startHost(port, 1, maxPoolSize, domainName);

    }

    public static void startHost(int port, int minPoolSize, int maxPoolSize, String domainName) {
        server = new Server(port, minPoolSize, maxPoolSize, domainName);
        server.start();
    }

    public static void stop() {
        server.stopServer();
    }

    public static Response sendRequest(String host, Request request) {
        return HostController.sendRequest(80, host, request);
    }

    public static Response sendRequest(int port, String host, Request request) {
        String response;
        try {
            HostController.OUTPUT_PORT.acquire();
            Socket connection = new Socket(InetAddress.getByName(host), port);
            connection.getOutputStream().write(request.toString().getBytes());
            InputStream input = connection.getInputStream();
            int available = input.available();
            while (available == 0) {
                Thread.sleep(0, 760_000);
                available = input.available();
            }
            response = new String(input.readNBytes(input.available()));
            if (input.available() == 0)
                connection.close();
        } catch (InterruptedException | IOException e) {
            HostController.logger.debug(e.getMessage());
            return null;
        } finally {
            HostController.OUTPUT_PORT.release();
        }
        return new Response(response);
    }
}
