package com.litehost.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientRequest implements Callable<ClientRequest>, Closeable {
    private Socket connection;
    private HttpRequest httpRequest;
    static Map<String, Method> requestMappings;
    private byte[] receivedBytes;
    private Response response;
    private InputStream input;
    private OutputStream output;


    ClientRequest(Socket request) throws IOException {
        this.connection = request;
        this.input = this.connection.getInputStream();
        this.output = this.connection.getOutputStream();
    }


    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    public void readRequest() throws IOException {
        int available;
        do {
            available = this.input.available();
        } while (available == 0);
        byte[] buffer = new byte[available];
        this.input.read(buffer, 0, available);
        this.receivedBytes = buffer;
    }

    public void sendResponse() throws IOException {
        this.output.write(this.response.toString().getBytes());
    }

    private Response invokeImplementedMethod()
            throws IllegalAccessException, InvocationTargetException, InstantiationException {
        String handlingSignature = this.httpRequest.getHandlingSignature();
        Method handlingMethod = ClientRequest.requestMappings.get(handlingSignature);
        List<String> variables = new ArrayList<>();
        if (handlingMethod == null) { //todo change to tree-like filter in future versions
            Optional<Map.Entry<String, Method>> optional = ClientRequest.requestMappings.entrySet().stream()
                    .filter(entry -> {
                        Pattern methodPattern = Pattern.compile(entry.getKey());
                        Matcher matcher = methodPattern.matcher(handlingSignature);
                        boolean found = matcher.find();
                        if (found) {
                            Pattern pattern = Pattern.compile("\\w+");
                            Matcher m = pattern.matcher(handlingSignature);
                            while (m.find()) {
                                String variableValue = m.group();
                                if (!entry.getKey().contains(variableValue))
                                    variables.add(variableValue);
                            }
                        }
                        return found;
                    }).findFirst();
            if (optional.isEmpty())
                return Response.builder().status(HttpStatus.INTERNAL_SERVER_ERROR).build();
            handlingMethod = optional.get().getValue();
        }
        Class<?> declaringClass = handlingMethod.getDeclaringClass();
        Parameter[] parameters = handlingMethod.getParameters();
        Constructor<?> defaultC = null;
        try {
            defaultC = declaringClass.getConstructor();
        } catch (NoSuchMethodException e) {
            //safe exception discarding, startup methods ensure defaultC exists
        }
        if (parameters.length == 1) {
            return ( Response ) handlingMethod.invoke(defaultC.newInstance(), new IncomingRequest(this.httpRequest, variables));
        }
        return ( Response ) handlingMethod.invoke(defaultC.newInstance());
    }

    @Override
    public ClientRequest call() {
        try {
            this.httpRequest = new HttpRequest(new String(receivedBytes));
            this.response = this.invokeImplementedMethod();
            return this;
        } catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            //safe discarding
        }
        return this;
    }
}