package io.gitlab.monstm.android.activity;

import android.annotation.SuppressLint;
import android.net.http.SslError;
import android.os.Bundle;
import android.webkit.SslErrorHandler;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import androidx.appcompat.app.AppCompatActivity;

abstract public class WebActivity extends AppCompatActivity {
	private LinearLayout layout;
	private WebView webview;


	@Override
	protected void onCreate(Bundle savedInstanceState){
		super.onCreate(savedInstanceState);

//		getActionBar().hide();
		getSupportActionBar().hide();

		initWebView();
		initLayout();
	}

	@SuppressLint("SetJavaScriptEnabled")
	private void initWebView(){
		webview = new WebView(this);
		webview.setWebViewClient(new WebViewClient(){
			@Override
			public void onReceivedSslError(WebView v, SslErrorHandler handler, SslError er){
				handler.proceed();
			}
		});

		WebSettings websettings = webview.getSettings();
		websettings.setJavaScriptEnabled(true);
	}

	private void initLayout(){
		layout = new LinearLayout(this);

		LinearLayout.LayoutParams layoutparams = new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.MATCH_PARENT,
				LinearLayout.LayoutParams.MATCH_PARENT
		);

		layout.setLayoutParams(layoutparams);

		layout.setOrientation(LinearLayout.HORIZONTAL);
		layout.addView(webview);

		setContentView(layout);
	}

	public void loadUrl(String Url){
		webview.loadUrl(Url);
	}
}
