/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.mguimard.openrgb.utils;

import io.gitlab.mguimard.openrgb.entity.ColorMode;
import io.gitlab.mguimard.openrgb.entity.DeviceType;
import io.gitlab.mguimard.openrgb.entity.ModeDirection;
import io.gitlab.mguimard.openrgb.entity.OpenRGBColor;
import io.gitlab.mguimard.openrgb.entity.OpenRGBDevice;
import io.gitlab.mguimard.openrgb.entity.OpenRGBLed;
import io.gitlab.mguimard.openrgb.entity.OpenRGBMode;
import io.gitlab.mguimard.openrgb.entity.OpenRGBZone;
import io.gitlab.mguimard.openrgb.entity.ZoneType;
import io.gitlab.mguimard.openrgb.utils.FlagsChecker;
import io.gitlab.mguimard.openrgb.utils.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DeviceParser {
    public static OpenRGBDevice from(ByteBuffer buffer, int serverProtocol) throws IOException {
        OpenRGBDevice device = new OpenRGBDevice();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.array());
        LittleEndianInputStream input = new LittleEndianInputStream(byteArrayInputStream);
        input.readInt();
        device.setType(DeviceType.values()[input.readInt()]);
        device.setName(input.readAscii());
        device.setVendor(serverProtocol >= 1 ? input.readAscii() : null);
        device.setDesc(input.readAscii());
        device.setVersion(input.readAscii());
        device.setSerial(input.readAscii());
        device.setLocation(input.readAscii());
        int modeCount = input.readUnsignedShort();
        device.setActiveMode(input.readInt());
        device.setModes(DeviceParser.readModes(input, modeCount));
        int zoneCount = input.readUnsignedShort();
        device.setZones(DeviceParser.readZones(input, zoneCount));
        int ledCount = input.readUnsignedShort();
        device.setLeds(DeviceParser.readLeds(input, ledCount));
        int colorCount = input.readUnsignedShort();
        device.setColors(DeviceParser.readColors(input, colorCount));
        return device;
    }

    private static List<OpenRGBMode> readModes(LittleEndianInputStream input, int modeCount) throws IOException {
        ArrayList<OpenRGBMode> openRGBModes = new ArrayList<OpenRGBMode>();
        for (int modeIndex = 0; modeIndex < modeCount; ++modeIndex) {
            ModeDirection direction;
            String modeName = input.readAscii();
            int value = input.readInt();
            int flags = input.readInt();
            FlagsChecker flagsChecker = new FlagsChecker(flags);
            int speedMin = 0;
            int speedMax = 0;
            if (flagsChecker.hasSpeed()) {
                speedMin = input.readInt();
                speedMax = input.readInt();
            } else {
                input.skip(8L);
            }
            int colorMin = 0;
            int colorMax = 0;
            if (flagsChecker.hasModeSpecificColor()) {
                colorMin = input.readInt();
                colorMax = input.readInt();
            } else {
                input.skip(8L);
            }
            int speed = 0;
            if (flagsChecker.hasSpeed()) {
                speed = input.readInt();
            } else {
                input.skip(4L);
            }
            if (flagsChecker.hasDirection()) {
                direction = ModeDirection.values()[input.readInt()];
            } else {
                direction = ModeDirection.MODE_DIRECTION_LEFT;
                input.skip(4L);
            }
            ColorMode colorMode = ColorMode.values()[input.readInt()];
            int colorLength = input.readUnsignedShort();
            ArrayList<OpenRGBColor> openRGBColors = new ArrayList<OpenRGBColor>();
            for (int colorIndex = 0; colorIndex < colorLength; ++colorIndex) {
                OpenRGBColor openRGBColor = DeviceParser.readColor(input);
                openRGBColors.add(openRGBColor);
            }
            openRGBModes.add(new OpenRGBMode(modeName, value, flags, speedMin, speedMax, colorMin, colorMax, speed, direction, colorMode, openRGBColors));
        }
        return openRGBModes;
    }

    private static List<OpenRGBZone> readZones(LittleEndianInputStream input, int zoneCount) throws IOException {
        ArrayList<OpenRGBZone> openRGBZones = new ArrayList<OpenRGBZone>();
        for (int zoneIndex = 0; zoneIndex < zoneCount; ++zoneIndex) {
            String zoneName = input.readAscii();
            ZoneType type = ZoneType.values()[input.readInt()];
            int ledsMin = input.readInt();
            int ledsMax = input.readInt();
            int ledsCount = input.readInt();
            int matrixSize = input.readUnsignedShort();
            int height = 0;
            int width = 0;
            if (matrixSize > 0) {
                height = input.readInt();
                width = input.readInt();
            }
            int[][] matrix = new int[height][width];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    matrix[i][j] = input.readInt();
                }
            }
            openRGBZones.add(new OpenRGBZone(zoneName, type, ledsMin, ledsMax, ledsCount, height, width, matrix));
        }
        return openRGBZones;
    }

    private static List<OpenRGBLed> readLeds(LittleEndianInputStream input, int ledCount) throws IOException {
        ArrayList<OpenRGBLed> leds = new ArrayList<OpenRGBLed>();
        for (int ledIndex = 0; ledIndex < ledCount; ++ledIndex) {
            String ledName = input.readAscii();
            OpenRGBColor openRGBColor = DeviceParser.readColor(input);
            leds.add(new OpenRGBLed(ledName, openRGBColor));
        }
        return leds;
    }

    private static List<OpenRGBColor> readColors(LittleEndianInputStream input, int colorCount) throws IOException {
        ArrayList<OpenRGBColor> colors = new ArrayList<OpenRGBColor>();
        for (int colorIndex = 0; colorIndex < colorCount; ++colorIndex) {
            colors.add(DeviceParser.readColor(input));
        }
        return colors;
    }

    private static OpenRGBColor readColor(LittleEndianInputStream input) throws IOException {
        OpenRGBColor color = new OpenRGBColor((byte)input.read(), (byte)input.read(), (byte)input.read());
        input.skip(1L);
        return color;
    }
}

