package io.gitlab.mguimard.openrgb.entity;

/**
 * Represents a LED in OpenRGB server
 */
public class OpenRGBLed {

    private String name;
    private OpenRGBColor value;

    /**
     * Default constructor, returns an instance of an OpenRGBLed
     *
     * @param name  Led name
     * @param value Led color, integer value
     */
    public OpenRGBLed(String name, OpenRGBColor value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenRGBColor getValue() {
        return value;
    }

    public void setValue(OpenRGBColor value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "OpenRGBLed{" +
                "name='" + name + '\'' +
                ", value=" + value +
                '}';
    }
}
