package io.gitlab.mguimard.openrgb.entity;

/**
 *
 */
public class OpenRGBColor {
    private byte red;
    private byte green;
    private byte blue;

    /**
     * Returns an instance of an OpenRGBColor
     *
     * @param red   the red value
     * @param green the green value
     * @param blue  the blue value
     */
    public OpenRGBColor(int red, int green, int blue) {
        this.red = (byte) red;
        this.green = (byte) green;
        this.blue = (byte) blue;
    }

    public static OpenRGBColor fromInt(int value) {
        return new OpenRGBColor(value >> 16 & 255, value >> 8 & 255, value & 255);
    }

    public static OpenRGBColor fromHexaString(String s) {
        return fromInt(Integer.decode(s));
    }

    public byte getRed() {
        return red;
    }

    public void setRed(byte red) {
        this.red = red;
    }

    public byte getGreen() {
        return green;
    }

    public void setGreen(byte green) {
        this.green = green;
    }

    public byte getBlue() {
        return blue;
    }

    public void setBlue(byte blue) {
        this.blue = blue;
    }

    @Override
    public String toString() {
        return "OpenRGBColor{" +
                "red=" + red +
                ", green=" + green +
                ", blue=" + blue +
                '}';
    }
}
