package io.gitlab.mguimard.openrgb.examples;

import io.gitlab.mguimard.openrgb.client.OpenRGBClient;
import io.gitlab.mguimard.openrgb.entity.OpenRGBDevice;
import io.gitlab.mguimard.openrgb.entity.OpenRGBMode;

import java.io.IOException;
import java.util.List;

public class SetMode {

    public static void main(String[] args) {
        OpenRGBClient client = new OpenRGBClient("localhost", 6742, "foo");
        int deviceId = 0;

        try {
            client.connect();
            OpenRGBDevice controller = client.getDeviceController(deviceId);
            List<OpenRGBMode> modes = controller.getModes();
            OpenRGBMode mode = modes.get(2);
            System.out.println(mode);

            mode.setSpeed(100);
            client.updateMode(deviceId, 2, mode);

            controller = client.getDeviceController(deviceId);
            modes = controller.getModes();
            mode = modes.get(2);
            System.out.println(mode);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
