/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.mguimard.openrgb.utils;

import io.gitlab.mguimard.openrgb.entity.OpenRGBColor;
import io.gitlab.mguimard.openrgb.entity.OpenRGBDevice;
import io.gitlab.mguimard.openrgb.entity.OpenRGBLed;
import io.gitlab.mguimard.openrgb.entity.OpenRGBMode;
import io.gitlab.mguimard.openrgb.entity.OpenRGBZone;
import io.gitlab.mguimard.openrgb.utils.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class DeviceParser {
    public static OpenRGBDevice from(ByteBuffer buffer, int serverProtocol) throws IOException {
        OpenRGBDevice device = new OpenRGBDevice();
        String s = new String(buffer.array(), StandardCharsets.US_ASCII);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.array());
        LittleEndianInputStream input = new LittleEndianInputStream(byteArrayInputStream);
        int duplicatePacketLength = input.readInt();
        device.setType(input.readInt());
        device.setName(input.readAscii());
        device.setVendor(serverProtocol >= 1 ? input.readAscii() : null);
        device.setDesc(input.readAscii());
        device.setVersion(input.readAscii());
        device.setSerial(input.readAscii());
        device.setLocation(input.readAscii());
        int modeCount = input.readUnsignedShort();
        device.setActiveMode(input.readInt());
        device.setModes(DeviceParser.readModes(input, modeCount));
        int zoneCount = input.readUnsignedShort();
        device.setZones(DeviceParser.readZones(input, zoneCount));
        int ledCount = input.readUnsignedShort();
        device.setLeds(DeviceParser.readLeds(input, ledCount));
        int colorCount = input.readUnsignedShort();
        device.setColors(DeviceParser.readColors(input, colorCount));
        return device;
    }

    private static List<OpenRGBMode> readModes(LittleEndianInputStream input, int modeCount) throws IOException {
        ArrayList<OpenRGBMode> openRGBModes = new ArrayList<OpenRGBMode>();
        for (int modeIndex = 0; modeIndex < modeCount; ++modeIndex) {
            String modeName = input.readAscii();
            int value = input.readInt();
            int flags = input.readInt();
            FlagsCheck flagsCheck = new FlagsCheck(flags);
            int speedMin = 0;
            int speedMax = 0;
            if (flagsCheck.hasSpeed()) {
                speedMin = input.readInt();
                speedMax = input.readInt();
            } else {
                input.skip(8L);
            }
            int colorMin = 0;
            int colorMax = 0;
            if (flagsCheck.hasModeSpecificColor()) {
                colorMin = input.readInt();
                colorMax = input.readInt();
            } else {
                input.skip(8L);
            }
            int speed = 0;
            if (flagsCheck.hasSpeed()) {
                speed = input.readInt();
            } else {
                input.skip(4L);
            }
            int direction = 0;
            if (flagsCheck.hasDirection()) {
                direction = input.readInt();
            } else {
                input.skip(4L);
            }
            int colorMode = input.readInt();
            int colorLength = input.readUnsignedShort();
            ArrayList<OpenRGBColor> openRGBColors = new ArrayList<OpenRGBColor>();
            for (int colorIndex = 0; colorIndex < colorLength; ++colorIndex) {
                OpenRGBColor openRGBColor = DeviceParser.readColor(input);
                openRGBColors.add(openRGBColor);
            }
            openRGBModes.add(new OpenRGBMode(modeName, value, flags, speedMin, speedMax, colorMin, colorMax, speed, direction, colorMode, openRGBColors));
        }
        return openRGBModes;
    }

    private static List<OpenRGBZone> readZones(LittleEndianInputStream input, int zoneCount) throws IOException {
        ArrayList<OpenRGBZone> openRGBZones = new ArrayList<OpenRGBZone>();
        for (int zoneIndex = 0; zoneIndex < zoneCount; ++zoneIndex) {
            String zoneName = input.readAscii();
            int type = input.readInt();
            int ledsMin = input.readInt();
            int ledsMax = input.readInt();
            int ledsCount = input.readInt();
            int matrixSize = input.readUnsignedShort();
            int height = 0;
            int width = 0;
            if (matrixSize > 0) {
                height = input.readInt();
                width = input.readInt();
            }
            int[][] matrix = new int[height][width];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    matrix[i][j] = input.readInt();
                }
            }
            openRGBZones.add(new OpenRGBZone(zoneName, type, ledsMin, ledsMax, ledsCount, height, width, matrix));
        }
        return openRGBZones;
    }

    private static List<OpenRGBLed> readLeds(LittleEndianInputStream input, int ledCount) throws IOException {
        ArrayList<OpenRGBLed> leds = new ArrayList<OpenRGBLed>();
        for (int ledIndex = 0; ledIndex < ledCount; ++ledIndex) {
            String ledName = input.readAscii();
            OpenRGBColor openRGBColor = DeviceParser.readColor(input);
            leds.add(new OpenRGBLed(ledName, openRGBColor));
        }
        return leds;
    }

    private static List<OpenRGBColor> readColors(LittleEndianInputStream input, int colorCount) throws IOException {
        ArrayList<OpenRGBColor> colors = new ArrayList<OpenRGBColor>();
        for (int colorIndex = 0; colorIndex < colorCount; ++colorIndex) {
            colors.add(DeviceParser.readColor(input));
        }
        return colors;
    }

    private static OpenRGBColor readColor(LittleEndianInputStream input) throws IOException {
        OpenRGBColor color = new OpenRGBColor((byte)input.read(), (byte)input.read(), (byte)input.read());
        input.skip(1L);
        return color;
    }

    static class FlagsCheck {
        int flags;

        FlagsCheck(int flags) {
            this.flags = flags;
        }

        boolean hasSpeed() {
            return (this.flags & 1) != 0;
        }

        boolean hasDirectionLR() {
            return this.checkBit(1);
        }

        boolean hasDirectionUP() {
            return this.checkBit(2);
        }

        boolean hasDirectionHv() {
            return this.checkBit(3);
        }

        boolean hasBrightness() {
            return this.checkBit(4);
        }

        boolean hasPerLedColor() {
            return this.checkBit(5);
        }

        boolean hasModeSpecificColor() {
            return this.checkBit(6);
        }

        boolean hasRandomColor() {
            return this.checkBit(7);
        }

        boolean hasDirection() {
            return (this.flags & 0xE) != 0;
        }

        boolean checkBit(int bit) {
            return (this.flags & 1) << bit != 0;
        }
    }
}

