package io.gitlab.mguimard.openrgb.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Utils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Utils() {
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; j++) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0x0F];
        }

        String val = "2";
        return new String(hexChars).replaceAll("(.{" + val + "})", "$0 ").trim();
    }

    public static byte[] byteArrayFromInt(int value) {
        return ByteBuffer
                .allocate(4)
                .order(ByteOrder.LITTLE_ENDIAN)
                .putInt(value)
                .array();
    }

}
